/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.source.ParsingContext;
import com.intellij.psi.impl.source.parsing.TokenProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;

public class MissingTokenInserter {
    protected final CompositeElement myRoot;
    protected final Lexer myLexer;
    private final int myStartOffset;
    private final int myEndOffset;
    private final int myState;
    private final TokenProcessor myProcessor;
    private final ParsingContext myContext;

    public MissingTokenInserter(CompositeElement root, Lexer lexer, int startOffset, int endOffset, int state, TokenProcessor processor, ParsingContext context) {
        this.myRoot = root;
        this.myLexer = lexer;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myState = state;
        this.myProcessor = processor;
        this.myContext = context;
    }

    public void invoke() {
        TreeElement firstMissing;
        TreeElement firstMissing2;
        if (this.myState < 0) {
            this.myLexer.start(this.myLexer.getBufferSequence(), this.myStartOffset, this.myEndOffset);
        } else {
            this.myLexer.start(this.myLexer.getBufferSequence(), this.myStartOffset, this.myEndOffset, this.myState);
        }
        TreeElement leaf = TreeUtil.findFirstLeafOrChameleon(this.myRoot);
        if (leaf == null) {
            TreeElement firstMissing3 = this.myProcessor.process(this.myLexer, this.myContext);
            if (firstMissing3 != null) {
                this.myRoot.rawAddChildren(firstMissing3);
            }
            return;
        }
        IElementType tokenType = this.getNextTokenType();
        if (tokenType != leaf.getElementType() && this.myProcessor.isTokenValid(tokenType) && (firstMissing2 = this.myProcessor.process(this.myLexer, this.myContext)) != null) {
            this.myRoot.getFirstChildNode().rawInsertBeforeMe(firstMissing2);
        }
        this.passTokenOrChameleon(leaf);
        this.insertMissingTokensInTreeBody(leaf);
        if (this.myLexer.getTokenType() != null && (firstMissing = this.myProcessor.process(this.myLexer, this.myContext)) != null) {
            CompositeElement current = this.myRoot;
            while (current instanceof CompositeElement && current.getUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY) == null) {
                current = current.getLastChildNode();
            }
            if (current instanceof CompositeElement) {
                current.rawAddChildren(firstMissing);
            } else {
                this.myRoot.getLastChildNode().rawInsertAfterMe(firstMissing);
            }
        }
    }

    protected IElementType getNextTokenType() {
        return this.myLexer.getTokenType();
    }

    private void insertMissingTokensInTreeBody(TreeElement leaf) {
        TreeUtil.CommonParentState commonParents = new TreeUtil.CommonParentState();
        while (leaf != null) {
            commonParents.strongWhiteSpaceHolder = null;
            IElementType tokenType = this.getNextTokenType();
            TreeElement next = TreeUtil.nextLeaf(leaf, commonParents, (IElementType)(tokenType instanceof ILazyParseableElementType ? tokenType : null), false);
            if (next == null || tokenType == null) break;
            if (tokenType != next.getElementType() && this.myProcessor.isTokenValid(tokenType)) {
                TreeElement firstMissing = this.myProcessor.process(this.myLexer, this.myContext);
                CompositeElement unclosedElement = commonParents.strongWhiteSpaceHolder;
                if (unclosedElement != null) {
                    if (commonParents.isStrongElementOnRisingSlope || unclosedElement.getFirstChildNode() == null) {
                        unclosedElement.rawAddChildren(firstMissing);
                    } else {
                        unclosedElement.getFirstChildNode().rawInsertBeforeMe(firstMissing);
                    }
                } else {
                    ASTNode insertBefore = commonParents.nextLeafBranchStart;
                    TreeElement insertAfter = commonParents.startLeafBranchStart;
                    TreeElement current = commonParents.startLeafBranchStart;
                    while (current != insertBefore) {
                        TreeElement treeNext = current.getTreeNext();
                        if (treeNext == insertBefore) {
                            insertAfter = current;
                            break;
                        }
                        if (this.isInsertAfterElement(treeNext)) {
                            insertAfter = current;
                            break;
                        }
                        if (treeNext.getUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY) != null) {
                            insertAfter = null;
                            ((CompositeElement)treeNext).rawAddChildren(firstMissing);
                            break;
                        }
                        current = treeNext;
                    }
                    if (insertAfter != null) {
                        insertAfter.rawInsertAfterMe(firstMissing);
                    }
                }
            }
            this.passTokenOrChameleon(next);
            leaf = next;
        }
    }

    protected boolean isInsertAfterElement(TreeElement treeNext) {
        return false;
    }

    private void passTokenOrChameleon(ASTNode node) {
        if (node instanceof LeafElement && node instanceof OuterLanguageElement || TreeUtil.isCollapsedChameleon(node)) {
            int endOfChameleon = node.getTextLength() + this.myLexer.getTokenStart();
            while (this.myLexer.getTokenType() != null && this.myLexer.getTokenEnd() < endOfChameleon) {
                this.myLexer.advance();
            }
        }
        this.advanceLexer(node);
    }

    protected void advanceLexer(ASTNode next) {
        this.myLexer.advance();
    }
}

