/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ImportHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.ImportHelper");
    private final CodeStyleSettings mySettings;
    @NonNls
    private static final String JAVA_LANG_PACKAGE = "java.lang";

    public ImportHelper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.<init> must not be null");
        }
        this.mySettings = settings;
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.prepareOptimizeImportsResult must not be null");
        }
        ArrayList<Pair<String, Boolean>> names = new ArrayList<Pair<String, Boolean>>(ImportHelper.collectNamesToImport(file));
        Collections.sort(names, new Comparator<Pair<String, Boolean>>(){

            @Override
            public int compare(Pair<String, Boolean> o1, Pair<String, Boolean> o2) {
                return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
            }
        });
        int[] entryForName = ArrayUtil.newIntArray((int)names.size());
        PackageEntry[] entries = this.mySettings.IMPORT_LAYOUT_TABLE.getEntries();
        for (int i = 0; i < names.size(); ++i) {
            Pair pair = (Pair)names.get(i);
            String string = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            entryForName[i] = ImportHelper.findEntryIndex(string, isStatic, entries);
        }
        ArrayList<Pair<String, Boolean>> resultList = new ArrayList<Pair<String, Boolean>>(names.size());
        for (int i = 0; i < entries.length; ++i) {
            for (int j = 0; j < names.size(); ++j) {
                if (entryForName[j] != i) continue;
                resultList.add((Pair<String, Boolean>)names.get(j));
                names.set(j, null);
            }
        }
        for (Pair pair : names) {
            if (pair == null) continue;
            resultList.add(pair);
        }
        TObjectIntHashMap packageToCountMap = new TObjectIntHashMap();
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        for (Pair pair : resultList) {
            int count;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String packageOrClassName = ImportHelper.getPackageOrClassName(name);
            if (packageOrClassName.length() == 0) continue;
            if (isStatic.booleanValue()) {
                count = tObjectIntHashMap.get((Object)packageOrClassName);
                tObjectIntHashMap.put((Object)packageOrClassName, count + 1);
                continue;
            }
            count = packageToCountMap.get((Object)packageOrClassName);
            packageToCountMap.put((Object)packageOrClassName, count + 1);
        }
        THashSet classesOrPackagesToImportOnDemand = new THashSet();
        class MyVisitorProcedure
        implements TObjectIntProcedure<String> {
            private final boolean myIsVisitingPackages;
            final /* synthetic */ Set val$classesOrPackagesToImportOnDemand;

            MyVisitorProcedure(boolean isVisitingPackages) {
                this.val$classesOrPackagesToImportOnDemand = set;
                this.myIsVisitingPackages = isVisitingPackages;
            }

            public boolean execute(String packageOrClassName, int count) {
                if (ImportHelper.this.isToUseImportOnDemand(packageOrClassName, count, !this.myIsVisitingPackages)) {
                    this.val$classesOrPackagesToImportOnDemand.add(packageOrClassName);
                }
                return true;
            }
        }
        tObjectIntHashMap.forEachEntry((TObjectIntProcedure)new MyVisitorProcedure(false));
        packageToCountMap.forEachEntry((TObjectIntProcedure)new MyVisitorProcedure(true));
        Set<String> set = ImportHelper.findSingleImports(file, resultList, (Set<String>)classesOrPackagesToImportOnDemand);
        THashSet toReimport = new THashSet();
        ImportHelper.calcClassesConflictingViaOnDemandImports(file, (Collection<String>)classesOrPackagesToImportOnDemand, file.getResolveScope(), (Set<String>)toReimport);
        set.addAll((Collection<String>)toReimport);
        try {
            StringBuilder text = ImportHelper.buildImportListText(resultList, (Set<String>)classesOrPackagesToImportOnDemand, set);
            String ext = StdFileTypes.JAVA.getDefaultExtension();
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)file.getProject());
            PsiJavaFile dummyFile = (PsiJavaFile)factory.createFileFromText("_Dummy_." + ext, (FileType)StdFileTypes.JAVA, (CharSequence)text);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file.getProject());
            codeStyleManager.reformat((PsiElement)dummyFile);
            PsiImportList result = dummyFile.getImportList();
            PsiImportList oldList = file.getImportList();
            if (oldList.isReplaceEquivalent(result)) {
                return null;
            }
            return result;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static Set<String> findSingleImports(@NotNull PsiJavaFile file, @NotNull List<Pair<String, Boolean>> names, @NotNull Set<String> onDemandImports) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findSingleImports must not be null");
        }
        if (names == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findSingleImports must not be null");
        }
        if (onDemandImports == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findSingleImports must not be null");
        }
        GlobalSearchScope resolveScope = file.getResolveScope();
        THashSet namesToUseSingle = new THashSet();
        String thisPackageName = file.getPackageName();
        THashSet implicitlyImportedPackages = new THashSet(Arrays.asList(file.getImplicitlyImportedPackages()));
        PsiManager manager = file.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        ArrayList<PsiClass> onDemandElements = new ArrayList<PsiClass>(onDemandImports.size());
        ArrayList<String> onDemandImportsList = new ArrayList<String>(onDemandImports);
        for (String string : onDemandImportsList) {
            PsiClass aClass = facade.findClass(string, resolveScope);
            onDemandElements.add(aClass);
        }
        for (Pair pair : names) {
            String langPackageClass;
            String thisPackageClass;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String prefix = ImportHelper.getPackageOrClassName(name);
            if (prefix.length() == 0) continue;
            boolean isImplicitlyImported = implicitlyImportedPackages.contains(prefix);
            if (!onDemandImports.contains(prefix) && !isImplicitlyImported) continue;
            String shortName = PsiNameHelper.getShortClassName((String)name);
            String string = thisPackageClass = thisPackageName.length() > 0 ? thisPackageName + "." + shortName : shortName;
            if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(thisPackageClass, resolveScope) != null) {
                namesToUseSingle.add(name);
                continue;
            }
            if (!isImplicitlyImported && facade.findClass(langPackageClass = "java.lang." + shortName, resolveScope) != null) {
                namesToUseSingle.add(name);
                continue;
            }
            for (int i = 0; i < onDemandImportsList.size(); ++i) {
                String onDemandName = (String)onDemandImportsList.get(i);
                if (prefix.equals(onDemandName)) continue;
                if (isStatic.booleanValue()) {
                    PsiMethod[] methods;
                    PsiElement element = (PsiElement)onDemandElements.get(i);
                    PsiClass aClass = (PsiClass)element;
                    if (aClass == null) continue;
                    PsiField field = aClass.findFieldByName(shortName, true);
                    if (field != null && field.hasModifierProperty("static")) {
                        namesToUseSingle.add(name);
                        continue;
                    }
                    PsiClass inner = aClass.findInnerClassByName(shortName, true);
                    if (inner != null && inner.hasModifierProperty("static")) {
                        namesToUseSingle.add(name);
                        continue;
                    }
                    for (PsiMethod method : methods = aClass.findMethodsByName(shortName, true)) {
                        if (!method.hasModifierProperty("static")) continue;
                        namesToUseSingle.add(name);
                    }
                    continue;
                }
                PsiClass aClass = facade.findClass(onDemandName + "." + shortName, resolveScope);
                if (aClass == null) continue;
                namesToUseSingle.add(name);
            }
        }
        THashSet tHashSet = namesToUseSingle;
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/ImportHelper.findSingleImports must not return null");
        }
        return tHashSet;
    }

    private static void calcClassesConflictingViaOnDemandImports(PsiJavaFile file, Collection<String> onDemandImportsList, GlobalSearchScope resolveScope, Set<String> namesToUseSingle) {
        ArrayList<String> onDemands = new ArrayList<String>(Arrays.asList(file.getImplicitlyImportedPackages()));
        onDemands.addAll(onDemandImportsList);
        if (onDemands.size() < 2) {
            return;
        }
        THashMap classNames = new THashMap();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
        for (int i = onDemands.size() - 1; i >= 0; --i) {
            String onDemand = (String)onDemands.get(i);
            PsiPackage aPackage = facade.findPackage(onDemand);
            if (aPackage == null) {
                onDemands.remove(i);
                continue;
            }
            PsiClass[] psiClasses = aPackage.getClasses(resolveScope);
            THashSet set = new THashSet(psiClasses.length);
            for (PsiClass psiClass : psiClasses) {
                set.add(psiClass.getName());
            }
            classNames.put(onDemand, set);
        }
        THashSet conflicts = new THashSet();
        for (int i = 0; i < onDemands.size(); ++i) {
            String on1 = (String)onDemands.get(i);
            for (int j = i + 1; j < onDemands.size(); ++j) {
                String on2 = (String)onDemands.get(j);
                THashSet inter = new THashSet((Collection)classNames.get(on1));
                inter.retainAll((Collection)classNames.get(on2));
                conflicts.addAll(inter);
            }
        }
        if (!conflicts.isEmpty()) {
            file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Set)conflicts, namesToUseSingle){
                final /* synthetic */ Set val$conflicts;
                final /* synthetic */ Set val$namesToUseSingle;
                {
                    this.val$conflicts = set;
                    this.val$namesToUseSingle = set2;
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    if (reference.getQualifier() != null) {
                        return;
                    }
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiClass && this.val$conflicts.contains(((PsiClass)element).getName())) {
                        String fqn = ((PsiClass)element).getQualifiedName();
                        this.val$namesToUseSingle.add(fqn);
                    }
                }
            });
        }
    }

    @NotNull
    private static StringBuilder buildImportListText(@NotNull List<Pair<String, Boolean>> names, @NotNull Set<String> packagesOrClassesToImportOnDemand, @NotNull Set<String> namesToUseSingle) {
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.buildImportListText must not be null");
        }
        if (packagesOrClassesToImportOnDemand == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.buildImportListText must not be null");
        }
        if (namesToUseSingle == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.buildImportListText must not be null");
        }
        THashSet importedPackagesOrClasses = new THashSet();
        StringBuilder buffer = new StringBuilder();
        for (Pair<String, Boolean> pair : names) {
            boolean useOnDemand;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String packageOrClassName = ImportHelper.getPackageOrClassName(name);
            boolean implicitlyImported = JAVA_LANG_PACKAGE.equals(packageOrClassName);
            boolean bl = useOnDemand = implicitlyImported || packagesOrClassesToImportOnDemand.contains(packageOrClassName);
            if (useOnDemand && namesToUseSingle.remove(name)) {
                useOnDemand = false;
            }
            if (useOnDemand && (importedPackagesOrClasses.contains(packageOrClassName) || implicitlyImported)) continue;
            buffer.append("import ");
            if (isStatic.booleanValue()) {
                buffer.append("static ");
            }
            if (useOnDemand) {
                importedPackagesOrClasses.add(packageOrClassName);
                buffer.append(packageOrClassName);
                buffer.append(".*");
            } else {
                buffer.append(name);
            }
            buffer.append(";\n");
        }
        for (String remainingSingle : namesToUseSingle) {
            buffer.append("import ");
            buffer.append(remainingSingle);
            buffer.append(";\n");
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/ImportHelper.buildImportListText must not return null");
        }
        return stringBuilder;
    }

    public boolean addImport(@NotNull PsiJavaFile file, @NotNull PsiClass refClass) {
        PsiPackage conflictPackageRef;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.addImport must not be null");
        }
        if (refClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.addImport must not be null");
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        PsiResolveHelper helper = facade.getResolveHelper();
        String className = refClass.getQualifiedName();
        if (className == null) {
            return true;
        }
        String packageName = ImportHelper.getPackageOrClassName(className);
        String shortName = PsiNameHelper.getShortClassName((String)className);
        PsiClass conflictSingleRef = ImportHelper.findSingleImportByShortName(file, shortName);
        if (conflictSingleRef != null) {
            return className.equals(conflictSingleRef.getQualifiedName());
        }
        PsiClass curRefClass = helper.resolveReferencedClass(shortName, (PsiElement)file);
        if (file.getManager().areElementsEquivalent((PsiElement)refClass, (PsiElement)curRefClass)) {
            return true;
        }
        boolean useOnDemand = true;
        if (packageName.length() == 0) {
            useOnDemand = false;
        }
        if ((conflictPackageRef = ImportHelper.findImportOnDemand(file, packageName)) != null) {
            useOnDemand = false;
        }
        ArrayList<PsiClass> classesToReimport = new ArrayList<PsiClass>();
        List<PsiJavaCodeReferenceElement> importRefs = ImportHelper.getImportsFromPackage(file, packageName);
        if (useOnDemand) {
            if (this.mySettings.USE_SINGLE_CLASS_IMPORTS && importRefs.size() + 1 < this.mySettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND && !this.mySettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(packageName)) {
                useOnDemand = false;
            }
            if (curRefClass != null) {
                useOnDemand = true;
            }
            if (useOnDemand) {
                PsiElement[] onDemandRefs = file.getOnDemandImports(false, true);
                ArrayList<String> refTexts = new ArrayList<String>(onDemandRefs.length);
                for (PsiElement ref : onDemandRefs) {
                    String refName = ref instanceof PsiClass ? ((PsiClass)ref).getQualifiedName() : ((PsiPackage)ref).getQualifiedName();
                    refTexts.add(refName);
                }
                ImportHelper.calcClassesToReimport(file, facade, helper, packageName, classesToReimport, refTexts);
            }
        }
        try {
            PsiImportList importList = file.getImportList();
            PsiImportStatement statement = useOnDemand ? factory.createImportStatementOnDemand(packageName) : factory.createImportStatement(refClass);
            importList.add((PsiElement)statement);
            if (useOnDemand) {
                for (PsiJavaCodeReferenceElement ref : importRefs) {
                    LOG.assertTrue(ref.getParent() instanceof PsiImportStatement);
                    if (!ref.isValid()) continue;
                    classesToReimport.add((PsiClass)ref.resolve());
                    PsiImportStatement importStatement = (PsiImportStatement)ref.getParent();
                    importStatement.delete();
                }
            }
            for (PsiClass aClass : classesToReimport) {
                if (aClass == null) continue;
                this.addImport(file, aClass);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static void calcClassesToReimport(PsiJavaFile file, JavaPsiFacade facade, PsiResolveHelper helper, String packageName, List<PsiClass> classesToReimport, Collection<String> onDemandRefs) {
        if (onDemandRefs.isEmpty()) {
            return;
        }
        PsiPackage aPackage = facade.findPackage(packageName);
        if (aPackage != null) {
            PsiDirectory[] dirs = aPackage.getDirectories();
            GlobalSearchScope resolveScope = file.getResolveScope();
            for (PsiDirectory dir : dirs) {
                PsiFile[] files;
                for (PsiFile aFile : files = dir.getFiles()) {
                    if (!(aFile instanceof PsiJavaFile)) continue;
                    String name = aFile.getVirtualFile().getNameWithoutExtension();
                    for (String refName : onDemandRefs) {
                        String conflictClassName2;
                        PsiClass conflictClass2;
                        String conflictClassName = refName + "." + name;
                        PsiClass conflictClass = facade.findClass(conflictClassName, resolveScope);
                        if (conflictClass == null || !helper.isAccessible((PsiMember)conflictClass, (PsiElement)file, null) || (conflictClass2 = facade.findClass(conflictClassName2 = packageName + "." + name, resolveScope)) == null || !helper.isAccessible((PsiMember)conflictClass2, (PsiElement)file, null) || ReferencesSearch.search((PsiElement)conflictClass, (SearchScope)new LocalSearchScope((PsiElement)file), (boolean)false).findFirst() == null) continue;
                        classesToReimport.add(conflictClass);
                    }
                }
            }
        }
    }

    @NotNull
    private static List<PsiJavaCodeReferenceElement> getImportsFromPackage(@NotNull PsiJavaFile file, @NotNull String packageName) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.getImportsFromPackage must not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.getImportsFromPackage must not be null");
        }
        PsiClass[] refs = file.getSingleClassImports(true);
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiClass ref1 : refs) {
            PsiJavaCodeReferenceElement ref;
            String className = ref1.getQualifiedName();
            if (!ImportHelper.getPackageOrClassName(className).equals(packageName) || (ref = file.findImportReferenceTo(ref1)) == null) continue;
            array.add(ref);
        }
        ArrayList<PsiJavaCodeReferenceElement> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/ImportHelper.getImportsFromPackage must not return null");
        }
        return arrayList;
    }

    private static PsiClass findSingleImportByShortName(@NotNull PsiJavaFile file, @NotNull String shortClassName) {
        String className;
        PsiClass[] refs;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findSingleImportByShortName must not be null");
        }
        if (shortClassName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findSingleImportByShortName must not be null");
        }
        for (PsiClass ref : refs = file.getSingleClassImports(true)) {
            className = ref.getQualifiedName();
            if (className == null || !PsiNameHelper.getShortClassName((String)className).equals(shortClassName)) continue;
            return ref;
        }
        for (PsiClass aClass : file.getClasses()) {
            className = aClass.getQualifiedName();
            if (className == null || !PsiNameHelper.getShortClassName((String)className).equals(shortClassName)) continue;
            return aClass;
        }
        return null;
    }

    private static PsiPackage findImportOnDemand(@NotNull PsiJavaFile file, @NotNull String packageName) {
        PsiElement[] refs;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findImportOnDemand must not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findImportOnDemand must not be null");
        }
        for (PsiElement ref : refs = file.getOnDemandImports(false, true)) {
            if (!(ref instanceof PsiPackage) || !((PsiPackage)ref).getQualifiedName().equals(packageName)) continue;
            return (PsiPackage)ref;
        }
        return null;
    }

    public ASTNode getDefaultAnchor(@NotNull PsiImportList list, @NotNull PsiImportStatementBase statement) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.getDefaultAnchor must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.getDefaultAnchor must not be null");
        }
        PsiJavaCodeReferenceElement ref = statement.getImportReference();
        if (ref == null) {
            return null;
        }
        int entryIndex = this.findEntryIndex(statement);
        PsiImportStatementBase[] allStatements = list.getAllImportStatements();
        int[] entries = ArrayUtil.newIntArray((int)allStatements.length);
        ArrayList<PsiImportStatementBase> statements = new ArrayList<PsiImportStatementBase>();
        for (int i = 0; i < allStatements.length; ++i) {
            int entryIndex1;
            PsiImportStatementBase statement1 = allStatements[i];
            entries[i] = entryIndex1 = this.findEntryIndex(statement1);
            if (entryIndex1 != entryIndex) continue;
            statements.add(statement1);
        }
        if (statements.isEmpty()) {
            int index;
            for (index = entries.length - 1; index >= 0 && entries[index] >= entryIndex; --index) {
            }
            return ++index < entries.length ? SourceTreeToPsiMap.psiElementToTree((PsiElement)allStatements[index]) : null;
        }
        String refText = ref.getCanonicalText();
        if (statement.isOnDemand()) {
            refText = refText + ".";
        }
        PsiImportStatementBase insertBefore = null;
        PsiImportStatementBase insertAfter = null;
        for (PsiImportStatementBase statement1 : statements) {
            int comp;
            PsiJavaCodeReferenceElement ref1 = statement1.getImportReference();
            if (ref1 == null) continue;
            String refTextThis = ref1.getCanonicalText();
            if (statement1.isOnDemand()) {
                refTextThis = refTextThis + ".";
            }
            if ((comp = Comparing.compare((Comparable)((Object)refText), (Comparable)((Object)refTextThis))) < 0 && insertBefore == null) {
                insertBefore = statement1;
            }
            if (comp <= 0) continue;
            insertAfter = statement1;
        }
        if (insertBefore != null) {
            return insertBefore.getNode();
        }
        if (insertAfter != null) {
            return insertAfter.getNode().getTreeNext();
        }
        return null;
    }

    public int getEmptyLinesBetween(@NotNull PsiImportStatementBase statement1, @NotNull PsiImportStatementBase statement2) {
        int index2;
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.getEmptyLinesBetween must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.getEmptyLinesBetween must not be null");
        }
        int index1 = this.findEntryIndex(statement1);
        if (index1 == (index2 = this.findEntryIndex(statement2))) {
            return 0;
        }
        if (index1 > index2) {
            int t = index1;
            index1 = index2;
            index2 = t;
        }
        PackageEntry[] entries = this.mySettings.IMPORT_LAYOUT_TABLE.getEntries();
        int maxSpace = 0;
        for (int i = index1 + 1; i < index2; ++i) {
            if (entries[i] != PackageEntry.BLANK_LINE_ENTRY) continue;
            int space = 0;
            do {
                ++space;
            } while (entries[++i] == PackageEntry.BLANK_LINE_ENTRY);
            maxSpace = Math.max(maxSpace, space);
        }
        return maxSpace;
    }

    private boolean isToUseImportOnDemand(@NotNull String packageName, int classCount, boolean isStaticImportNeeded) {
        int limitCount;
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.isToUseImportOnDemand must not be null");
        }
        if (!this.mySettings.USE_SINGLE_CLASS_IMPORTS) {
            return true;
        }
        int n = limitCount = isStaticImportNeeded ? this.mySettings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND : this.mySettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
        if (classCount >= limitCount) {
            return true;
        }
        if (packageName.length() == 0) {
            return false;
        }
        PackageEntryTable table = this.mySettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
        return table != null && table.contains(packageName);
    }

    private static int findEntryIndex(@NotNull String packageName, boolean isStatic, @NotNull PackageEntry[] entries) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findEntryIndex must not be null");
        }
        if (entries == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findEntryIndex must not be null");
        }
        PackageEntry bestEntry = null;
        int bestEntryIndex = -1;
        int allOtherStaticIndex = -1;
        int allOtherIndex = -1;
        for (int i = 0; i < entries.length; ++i) {
            PackageEntry entry = entries[i];
            if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                allOtherStaticIndex = i;
            }
            if (entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY) {
                allOtherIndex = i;
            }
            if (!entry.isBetterMatchForPackageThan(bestEntry, packageName, isStatic)) continue;
            bestEntry = entry;
            bestEntryIndex = i;
        }
        if (bestEntryIndex == -1 && isStatic && allOtherStaticIndex == -1 && allOtherIndex != -1) {
            bestEntryIndex = allOtherIndex;
        }
        return bestEntryIndex;
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement) {
        String packageName;
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.findEntryIndex must not be null");
        }
        PsiJavaCodeReferenceElement ref = statement.getImportReference();
        if (ref == null) {
            return -1;
        }
        if (statement.isOnDemand()) {
            packageName = ref.getCanonicalText();
        } else {
            String className = ref.getCanonicalText();
            packageName = ImportHelper.getPackageOrClassName(className);
        }
        return ImportHelper.findEntryIndex(packageName, statement instanceof PsiImportStaticStatement, this.mySettings.IMPORT_LAYOUT_TABLE.getEntries());
    }

    @NotNull
    private static Collection<Pair<String, Boolean>> collectNamesToImport(@NotNull PsiJavaFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.collectNamesToImport must not be null");
        }
        THashSet names = new THashSet();
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        ImportHelper.collectNamesToImport((Set<Pair<String, Boolean>>)names, file, (PsiFile)jspFile);
        if (jspFile != null) {
            PsiFile[] files;
            for (PsiFile includingFile : files = (PsiFile[])ArrayUtil.mergeArrays((Object[])JspSpiUtil.getIncludingFiles(jspFile), (Object[])JspSpiUtil.getIncludedFiles(jspFile), PsiFile.class)) {
                PsiFile javaRoot = includingFile.getViewProvider().getPsi(StdLanguages.JAVA);
                if (!(javaRoot instanceof PsiJavaFile) || file == javaRoot) continue;
                ImportHelper.collectNamesToImport((Set<Pair<String, Boolean>>)names, (PsiJavaFile)javaRoot, (PsiFile)jspFile);
            }
        }
        ImportHelper.addUnresolvedImportNames((Set<Pair<String, Boolean>>)names, file);
        THashSet tHashSet = names;
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/ImportHelper.collectNamesToImport must not return null");
        }
        return tHashSet;
    }

    private static void collectNamesToImport(@NotNull Set<Pair<String, Boolean>> names, @NotNull PsiJavaFile file, PsiFile context) {
        PsiFile[] roots;
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.collectNamesToImport must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.collectNamesToImport must not be null");
        }
        String packageName = file.getPackageName();
        for (PsiFile root : roots = file.getPsiRoots()) {
            ImportHelper.addNamesToImport(names, (PsiElement)root, packageName, context);
        }
    }

    private static void addNamesToImport(@NotNull Set<Pair<String, Boolean>> names, @NotNull PsiElement scope, @NotNull String thisPackageName, PsiFile context) {
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.addNamesToImport must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.addNamesToImport must not be null");
        }
        if (thisPackageName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.addNamesToImport must not be null");
        }
        if (scope instanceof PsiImportList) {
            return;
        }
        LinkedList<PsiElement> stack = new LinkedList<PsiElement>();
        stack.add(scope);
        while (!stack.isEmpty()) {
            PsiElement child = (PsiElement)stack.removeFirst();
            if (child instanceof PsiImportList || child instanceof PsiLiteralExpression) continue;
            stack.addAll(Arrays.asList(child.getChildren()));
            for (PsiReference reference : child.getReferences()) {
                String qName;
                PsiElement currentFileResolveScope;
                PsiJavaReference javaReference;
                if (!(reference instanceof PsiJavaReference) || (javaReference = (PsiJavaReference)reference) instanceof JavaClassReference && ((JavaClassReference)javaReference).getContextReference() != null) continue;
                PsiJavaCodeReferenceElement referenceElement = null;
                if (reference instanceof PsiJavaCodeReferenceElement && ((referenceElement = (PsiJavaCodeReferenceElement)child).getQualifier() != null || reference instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)reference).getKind() == 6)) continue;
                JavaResolveResult resolveResult = javaReference.advancedResolve(true);
                PsiElement refElement = resolveResult.getElement();
                if (refElement == null && referenceElement != null) {
                    refElement = ResolveClassUtil.resolveClass(referenceElement);
                }
                if (refElement == null || !((currentFileResolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) || context != null && (!currentFileResolveScope.isValid() || currentFileResolveScope instanceof JspxImportStatement && context != ((JspxImportStatement)currentFileResolveScope).getDeclarationFile())) continue;
                if (referenceElement != null && currentFileResolveScope instanceof PsiImportStaticStatement) {
                    String refName;
                    PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
                    String name = importStaticStatement.getImportReference().getCanonicalText();
                    if (importStaticStatement.isOnDemand() && (refName = referenceElement.getReferenceName()) != null) {
                        name = name + "." + refName;
                    }
                    names.add((Pair<String, Boolean>)Pair.create((Object)name, (Object)Boolean.TRUE));
                    continue;
                }
                if (!(refElement instanceof PsiClass) || ImportHelper.hasPackage(qName = ((PsiClass)refElement).getQualifiedName(), thisPackageName)) continue;
                names.add((Pair<String, Boolean>)Pair.create((Object)qName, (Object)Boolean.FALSE));
            }
        }
    }

    private static void addUnresolvedImportNames(@NotNull Set<Pair<String, Boolean>> names, @NotNull PsiJavaFile file) {
        PsiImportStatementBase[] imports;
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.addUnresolvedImportNames must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.addUnresolvedImportNames must not be null");
        }
        for (PsiImportStatementBase anImport : imports = file.getImportList().getAllImportStatements()) {
            JavaResolveResult[] results;
            PsiJavaCodeReferenceElement ref = anImport.getImportReference();
            if (ref == null || (results = ref.multiResolve(false)).length != 0) continue;
            String text = ref.getCanonicalText();
            if (anImport.isOnDemand()) {
                text = text + ".*";
            }
            names.add((Pair<String, Boolean>)Pair.create((Object)text, (Object)(anImport instanceof PsiImportStaticStatement)));
        }
    }

    public static boolean isImplicitlyImported(@NotNull String className, @NotNull PsiJavaFile file) {
        String[] packageNames;
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.isImplicitlyImported must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.isImplicitlyImported must not be null");
        }
        for (String packageName : packageNames = file.getImplicitlyImportedPackages()) {
            if (!ImportHelper.hasPackage(className, packageName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPackage(@NotNull String className, @NotNull String packageName) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.hasPackage must not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.hasPackage must not be null");
        }
        if (!className.startsWith(packageName)) {
            return false;
        }
        if (className.length() == packageName.length()) {
            return false;
        }
        if (packageName.length() > 0 && className.charAt(packageName.length()) != '.') {
            return false;
        }
        return className.indexOf(46, packageName.length() + 1) < 0;
    }

    @NotNull
    private static String getPackageOrClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ImportHelper.getPackageOrClassName must not be null");
        }
        int dotIndex = className.lastIndexOf(46);
        String string = dotIndex < 0 ? "" : className.substring(0, dotIndex);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/ImportHelper.getPackageOrClassName must not return null");
        }
        return string;
    }
}

