/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.compiled.ClsReferenceListImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.source.PsiReferenceListImpl;
import com.intellij.psi.impl.source.tree.java.PsiTypeParameterExtendsBoundsListImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaClassReferenceListElementType
extends JavaStubElementType<PsiClassReferenceListStub, PsiReferenceList> {
    public JavaClassReferenceListElementType(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType.<init> must not be null");
        }
        super(id);
    }

    public PsiReferenceList createPsi(PsiClassReferenceListStub stub) {
        if (this.isCompiled(stub)) {
            return new ClsReferenceListImpl(stub);
        }
        if (stub.getRole() == PsiReferenceList.Role.EXTENDS_BOUNDS_LIST) {
            return new PsiTypeParameterExtendsBoundsListImpl(stub, (IStubElementType)JavaStubElementTypes.EXTENDS_BOUND_LIST);
        }
        return new PsiReferenceListImpl(stub, stub.getStubType());
    }

    @Override
    public PsiReferenceList createPsi(ASTNode node) {
        if (node.getElementType() == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            return new PsiTypeParameterExtendsBoundsListImpl(node);
        }
        return new PsiReferenceListImpl(node);
    }

    public PsiClassReferenceListStub createStub(PsiReferenceList psi, StubElement parentStub) {
        return new PsiClassReferenceListStubImpl(JavaClassReferenceListElementType.roleToElementType(psi.getRole()), parentStub, JavaClassReferenceListElementType.getTexts(psi), psi.getRole());
    }

    private static JavaClassReferenceListElementType roleToElementType(PsiReferenceList.Role role) {
        switch (role) {
            case EXTENDS_BOUNDS_LIST: {
                return JavaStubElementTypes.EXTENDS_BOUND_LIST;
            }
            case EXTENDS_LIST: {
                return JavaStubElementTypes.EXTENDS_LIST;
            }
            case IMPLEMENTS_LIST: {
                return JavaStubElementTypes.IMPLEMENTS_LIST;
            }
            case THROWS_LIST: {
                return JavaStubElementTypes.THROWS_LIST;
            }
        }
        throw new RuntimeException("Unknown role: " + role);
    }

    private static String[] getTexts(PsiReferenceList psi) {
        PsiJavaCodeReferenceElement[] refs = psi.getReferenceElements();
        String[] texts = ArrayUtil.newStringArray((int)refs.length);
        for (int i = 0; i < refs.length; ++i) {
            PsiJavaCodeReferenceElement ref = refs[i];
            texts[i] = ref instanceof PsiCompiledElement ? ref.getCanonicalText() : ref.getText();
        }
        return texts;
    }

    public void serialize(PsiClassReferenceListStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeByte((int)JavaClassReferenceListElementType.encodeRole(stub.getRole()));
        String[] names = stub.getReferencedNames();
        dataStream.writeVarInt(names.length);
        for (String name : names) {
            dataStream.writeName(name);
        }
    }

    public PsiClassReferenceListStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        byte role = dataStream.readByte();
        int len = dataStream.readVarInt();
        StringRef[] names = StringRef.createArray((int)len);
        for (int i = 0; i < names.length; ++i) {
            names[i] = dataStream.readName();
        }
        PsiReferenceList.Role decodedRole = JavaClassReferenceListElementType.decodeRole(role);
        return new PsiClassReferenceListStubImpl(JavaClassReferenceListElementType.roleToElementType(decodedRole), parentStub, names, decodedRole);
    }

    private static PsiReferenceList.Role decodeRole(int code) {
        switch (code) {
            case 0: {
                return PsiReferenceList.Role.EXTENDS_LIST;
            }
            case 1: {
                return PsiReferenceList.Role.IMPLEMENTS_LIST;
            }
            case 2: {
                return PsiReferenceList.Role.THROWS_LIST;
            }
            case 3: {
                return PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
            }
        }
        throw new RuntimeException("Unknown role code: " + code);
    }

    private static byte encodeRole(PsiReferenceList.Role role) {
        switch (role) {
            case EXTENDS_LIST: {
                return 0;
            }
            case IMPLEMENTS_LIST: {
                return 1;
            }
            case THROWS_LIST: {
                return 2;
            }
            case EXTENDS_BOUNDS_LIST: {
                return 3;
            }
        }
        throw new RuntimeException("Unknown role code: " + role);
    }

    public void indexStub(PsiClassReferenceListStub stub, IndexSink sink) {
        PsiReferenceList.Role role = stub.getRole();
        if (role == PsiReferenceList.Role.EXTENDS_LIST || role == PsiReferenceList.Role.IMPLEMENTS_LIST) {
            StubElement parentStub;
            String[] names;
            for (String name : names = stub.getReferencedNames()) {
                sink.occurrence(JavaSuperClassNameOccurenceIndex.KEY, (Object)PsiNameHelper.getShortClassName((String)name));
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST && (parentStub = stub.getParentStub()) instanceof PsiClassStub) {
                PsiClassStub psiClassStub = (PsiClassStub)parentStub;
                if (psiClassStub.isEnum()) {
                    sink.occurrence(JavaSuperClassNameOccurenceIndex.KEY, (Object)"Enum");
                }
                if (psiClassStub.isAnnotationType()) {
                    sink.occurrence(JavaSuperClassNameOccurenceIndex.KEY, (Object)"Annotation");
                }
            }
        }
    }
}

