/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class ClsElementImpl
extends PsiElementBase
implements PsiCompiledElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsElementImpl");
    private static final boolean CHECK_MIRROR_ENABLED = false;
    protected static final Object LAZY_BUILT_LOCK = new String("lazy cls tree initialization lock");
    public static final Key<PsiCompiledElement> COMPILED_ELEMENT = Key.create((String)"COMPILED_ELEMENT");
    private TreeElement myMirror = null;
    protected static final String CAN_NOT_MODIFY_MESSAGE = PsiBundle.message((String)"psi.error.attempt.to.edit.class.file", (Object[])new Object[0]);

    @NotNull
    public Language getLanguage() {
        Language language = StdFileTypes.JAVA.getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsElementImpl.getLanguage must not return null");
        }
        return language;
    }

    public PsiManager getManager() {
        return this.getParent().getManager();
    }

    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            if (!this.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)this);
            }
            return null;
        }
        return parent.getContainingFile();
    }

    public final boolean isWritable() {
        return false;
    }

    public boolean isPhysical() {
        return true;
    }

    public boolean isValid() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isValid();
    }

    public PsiElement copy() {
        return this;
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsElementImpl.checkAdd must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsElementImpl.add must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsElementImpl.addBefore must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsElementImpl.addAfter must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsElementImpl.replace must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public abstract void appendMirrorText(int var1, StringBuffer var2);

    protected static void goNextLine(int indentLevel, StringBuffer buffer) {
        buffer.append('\n');
        for (int i = 0; i < indentLevel; ++i) {
            buffer.append(' ');
        }
    }

    protected int getIndentSize() {
        return CodeStyleSettingsManager.getSettings((Project)this.getProject()).getIndentSize((FileType)StdFileTypes.JAVA);
    }

    public abstract void setMirror(@NotNull TreeElement var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiElement getMirror() {
        Object object = ClsFileImpl.MIRROR_LOCK;
        synchronized (object) {
            if (this.myMirror == null) {
                ClsFileImpl file = (ClsFileImpl)this.getContainingFile();
                file.getMirror();
            }
            return SourceTreeToPsiMap.treeElementToPsi(this.myMirror);
        }
    }

    public final TextRange getTextRange() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextRange() : new TextRange(0, 0);
    }

    public final int getStartOffsetInParent() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getStartOffsetInParent() : -1;
    }

    public int getTextLength() {
        String text = this.getText();
        if (text == null) {
            LOG.error("getText() == null, element = " + (Object)((Object)this) + ", parent = " + this.getParent());
            return 0;
        }
        return text.length();
    }

    public PsiElement findElementAt(int offset) {
        PsiElement mirrorAt = this.getMirror().findElementAt(offset);
        while (mirrorAt != null) {
            PsiElement elementAt = this.mirrorToElement(mirrorAt);
            if (elementAt != null) {
                return elementAt;
            }
            mirrorAt = mirrorAt.getParent();
        }
        return null;
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        PsiReference mirrorRef = this.getMirror().findReferenceAt(offset);
        if (mirrorRef == null) {
            return null;
        }
        PsiElement mirrorElement = mirrorRef.getElement();
        PsiElement element = this.mirrorToElement(mirrorElement);
        if (element == null) {
            return null;
        }
        return element.getReference();
    }

    private PsiElement mirrorToElement(PsiElement mirror) {
        PsiElement m = this.getMirror();
        if (m == mirror) {
            return this;
        }
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        for (PsiElement child : children) {
            PsiElement element;
            ClsElementImpl clsChild = (ClsElementImpl)child;
            if (!PsiTreeUtil.isAncestor((PsiElement)clsChild.getMirror(), (PsiElement)mirror, (boolean)false) || (element = clsChild.mirrorToElement(mirror)) == null) continue;
            return element;
        }
        return null;
    }

    public final int getTextOffset() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextOffset() : -1;
    }

    public String getText() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getText() : null;
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getMirror().textToCharArray();
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsElementImpl.textToCharArray must not return null");
        }
        return cArray;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsElementImpl.textMatches must not be null");
        }
        return this.getText().equals(((Object)text).toString());
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsElementImpl.textMatches must not be null");
        }
        return this.getText().equals(element.getText());
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        ClsElementImpl clsElementImpl = this;
        if (clsElementImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsElementImpl.getNavigationElement must not return null");
        }
        return clsElementImpl;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    public ASTNode getNode() {
        return null;
    }

    protected void setMirrorCheckingType(@NotNull TreeElement element, IElementType type) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsElementImpl.setMirrorCheckingType must not be null");
        }
        if (type != null) {
            LOG.assertTrue(element.getElementType() == type);
        }
        element.putUserData(COMPILED_ELEMENT, (Object)this);
        this.myMirror = element;
    }
}

