/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lexer.JavaLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiNameHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNameHelperImpl
extends PsiNameHelper {
    private final LanguageLevelProjectExtension myLanguageLevelExtension;

    public PsiNameHelperImpl(JavaPsiFacade manager) {
        this.myLanguageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)manager.getProject());
    }

    public boolean isIdentifier(@Nullable String text) {
        return this.isIdentifier(text, this.myLanguageLevelExtension.getLanguageLevel());
    }

    public boolean isIdentifier(@Nullable String text, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiNameHelperImpl.isIdentifier must not be null");
        }
        return text != null && StringUtil.isJavaIdentifier((String)text) && !JavaLexer.isKeyword(text, languageLevel);
    }

    public boolean isKeyword(@Nullable String text) {
        return text != null && JavaLexer.isKeyword(text, this.myLanguageLevelExtension.getLanguageLevel());
    }

    public boolean isQualifiedName(@Nullable String text) {
        if (text == null) {
            return false;
        }
        int index = 0;
        while (true) {
            int index1;
            if ((index1 = text.indexOf(46, index)) < 0) {
                index1 = text.length();
            }
            if (!this.isIdentifier(text.substring(index, index1))) {
                return false;
            }
            if (index1 == text.length()) {
                return true;
            }
            index = index1 + 1;
        }
    }
}

