/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ConstantExpressionVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConstantExpressionEvaluator
extends JavaRecursiveElementWalkingVisitor {
    private final Factory<ConcurrentMap<PsiElement, Object>> myMapFactory;
    private final Project myProject;
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY = Key.create((String)"CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY");
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY = Key.create((String)"CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY");
    private static final Object NO_VALUE = new Object();
    private final ConstantExpressionVisitor myConstantExpressionVisitor;
    private static final CachedValueProvider<ConcurrentMap<PsiElement, Object>> PROVIDER = new CachedValueProvider<ConcurrentMap<PsiElement, Object>>(){

        public CachedValueProvider.Result<ConcurrentMap<PsiElement, Object>> compute() {
            ConcurrentSoftHashMap value = new ConcurrentSoftHashMap();
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };

    private JavaConstantExpressionEvaluator(Set<PsiVariable> visitedVars, final boolean throwExceptionOnOverflow, Project project, final PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        this.myMapFactory = auxEvaluator != null ? new Factory<ConcurrentMap<PsiElement, Object>>(){

            public ConcurrentMap<PsiElement, Object> create() {
                return auxEvaluator.getCacheMap(throwExceptionOnOverflow);
            }
        } : new Factory<ConcurrentMap<PsiElement, Object>>(){

            public ConcurrentMap<PsiElement, Object> create() {
                Key key = throwExceptionOnOverflow ? CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY : CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY;
                return (ConcurrentMap)CachedValuesManager.getManager((Project)JavaConstantExpressionEvaluator.this.myProject).getCachedValue((UserDataHolder)JavaConstantExpressionEvaluator.this.myProject, key, PROVIDER, false);
            }
        };
        this.myProject = project;
        this.myConstantExpressionVisitor = new ConstantExpressionVisitor(visitedVars, throwExceptionOnOverflow, auxEvaluator);
    }

    protected void elementFinished(PsiElement element) {
        Object value = this.getCached(element);
        if (value == null) {
            Object result = this.myConstantExpressionVisitor.handle(element);
            this.cache(element, result);
        }
    }

    public void visitElement(PsiElement element) {
        Object value = this.getCached(element);
        if (value == null) {
            super.visitElement(element);
        } else {
            ConstantExpressionVisitor.store(element, value == NO_VALUE ? null : value);
        }
    }

    private Object getCached(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaConstantExpressionEvaluator.getCached must not be null");
        }
        return this.map().get(element);
    }

    private Object cache(@NotNull PsiElement element, @Nullable Object value) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaConstantExpressionEvaluator.cache must not be null");
        }
        value = ConcurrencyUtil.cacheOrGet(this.map(), (Object)element, (Object)(value == null ? NO_VALUE : value));
        if (value == NO_VALUE) {
            value = null;
        }
        return value;
    }

    @NotNull
    private ConcurrentMap<PsiElement, Object> map() {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.myMapFactory.create();
        if (concurrentMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaConstantExpressionEvaluator.map must not return null");
        }
        return concurrentMap;
    }

    public static Object computeConstantExpression(PsiExpression expression, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression, visitedVars, throwExceptionOnOverflow, null);
    }

    public static Object computeConstantExpression(PsiExpression expression, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression == null) {
            return null;
        }
        JavaConstantExpressionEvaluator evaluator = new JavaConstantExpressionEvaluator(visitedVars, throwExceptionOnOverflow, expression.getProject(), auxEvaluator);
        if (expression instanceof PsiCompiledElement) {
            if (expression instanceof PsiPrefixExpression) {
                PsiExpression operand = ((PsiPrefixExpression)expression).getOperand();
                if (operand == null) {
                    return null;
                }
                Object value = evaluator.myConstantExpressionVisitor.handle((PsiElement)operand);
                ConstantExpressionVisitor.store((PsiElement)operand, value);
            }
            return evaluator.myConstantExpressionVisitor.handle((PsiElement)expression);
        }
        expression.accept((PsiElementVisitor)evaluator);
        Object cached = evaluator.getCached((PsiElement)expression);
        return cached == NO_VALUE ? null : cached;
    }

    public static Object computeConstantExpression(PsiExpression expression, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression, null, throwExceptionOnOverflow);
    }
}

