/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.FilterUtil;
import com.intellij.psi.filters.InitializableFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.infos.CandidateInfo;
import java.util.ArrayList;

public class AssignableToFilter
implements InitializableFilter {
    private PsiType myType = null;
    private ElementFilter myFilter = null;

    public AssignableToFilter(PsiType type) {
        this.myType = type;
    }

    public AssignableToFilter() {
    }

    @Override
    public void init(Object[] type) {
        this.myFilter = new OrFilter();
        ArrayList<AssignableToFilter> filters = new ArrayList<AssignableToFilter>();
        for (Object o : type) {
            PsiType currentType = null;
            if (o instanceof PsiType) {
                currentType = (PsiType)o;
            } else if (o instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)o;
                currentType = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
            }
            if (currentType == null) continue;
            filters.add(new AssignableToFilter(currentType));
        }
        this.myFilter = new OrFilter(filters.toArray(new ElementFilter[filters.size()]));
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (this.myType != null) {
            if (element == null) {
                return false;
            }
            if (element instanceof PsiType) {
                return this.myType.isAssignableFrom((PsiType)element);
            }
            PsiSubstitutor substitutor = null;
            if (element instanceof CandidateInfo) {
                CandidateInfo info = (CandidateInfo)element;
                substitutor = info.getSubstitutor();
                element = info.getElement();
            }
            PsiType typeByElement = FilterUtil.getTypeByElement((PsiElement)element, context);
            if (substitutor != null) {
                typeByElement = substitutor.substitute(typeByElement);
            }
            return typeByElement != null && typeByElement.isAssignableFrom(this.myType) && !typeByElement.equals(this.myType);
        }
        if (this.myFilter != null) {
            if (element == null) {
                return false;
            }
            return this.myFilter.isAcceptable(element, context);
        }
        return false;
    }

    public String toString() {
        if (this.myType != null) {
            return "assignable-to(" + this.myType + ")";
        }
        if (this.myFilter != null) {
            return this.myFilter.toString();
        }
        return "uninitialized-equals-filter";
    }
}

