/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeFocusManagerImpl
extends IdeFocusManager {
    private final ToolWindowManagerImpl myToolWindowManager;

    public IdeFocusManagerImpl(ToolWindowManagerImpl twManager) {
        this.myToolWindowManager = twManager;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/IdeFocusManagerImpl.requestFocus must not be null");
        }
        ActionCallback actionCallback = IdeFocusManagerImpl.getGlobalInstance().requestFocus(c, forced);
        if (actionCallback == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/impl/IdeFocusManagerImpl.requestFocus must not return null");
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/IdeFocusManagerImpl.requestFocus must not be null");
        }
        ActionCallback actionCallback = IdeFocusManagerImpl.getGlobalInstance().requestFocus(command, forced);
        if (actionCallback == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/impl/IdeFocusManagerImpl.requestFocus must not return null");
        }
        return actionCallback;
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/IdeFocusManagerImpl.getFocusTargetFor must not be null");
        }
        return IdeFocusManagerImpl.getGlobalInstance().getFocusTargetFor(comp);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/IdeFocusManagerImpl.doWhenFocusSettlesDown must not be null");
        }
        IdeFocusManagerImpl.getGlobalInstance().doWhenFocusSettlesDown(runnable);
    }

    @Nullable
    public Component getFocusedDescendantFor(@NotNull Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/IdeFocusManagerImpl.getFocusedDescendantFor must not be null");
        }
        return IdeFocusManagerImpl.getGlobalInstance().getFocusedDescendantFor(comp);
    }

    public boolean dispatch(KeyEvent e) {
        return IdeFocusManagerImpl.getGlobalInstance().dispatch(e);
    }

    public void suspendKeyProcessingUntil(@NotNull ActionCallback done) {
        if (done == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/IdeFocusManagerImpl.suspendKeyProcessingUntil must not be null");
        }
        IdeFocusManagerImpl.getGlobalInstance().suspendKeyProcessingUntil(done);
    }

    public ActionCallback requestDefaultFocus(boolean forced) {
        return this.myToolWindowManager.requestDefaultFocus(forced);
    }

    public boolean isFocusTransferEnabled() {
        return IdeFocusManagerImpl.getGlobalInstance().isFocusTransferEnabled();
    }

    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        return IdeFocusManagerImpl.getGlobalInstance().getTimestamp(trackOnlyForcedCommands);
    }

    public FocusRequestor getFurtherRequestor() {
        return IdeFocusManagerImpl.getGlobalInstance().getFurtherRequestor();
    }

    public boolean isFocusBeingTransferred() {
        return IdeFocusManagerImpl.getGlobalInstance().isFocusBeingTransferred();
    }
}

