/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.File;

public class CompositeCheckoutListener
implements CheckoutProvider.Listener {
    private final Project myProject;
    private boolean myFoundProject = false;
    private File myFirstDirectory;

    public CompositeCheckoutListener(Project project) {
        this.myProject = project;
    }

    public void directoryCheckedOut(File directory) {
        VirtualFile virtualFile;
        if (!this.myFoundProject && (virtualFile = CompositeCheckoutListener.refreshVFS(directory)) != null) {
            if (this.myFirstDirectory == null) {
                this.myFirstDirectory = directory;
            }
            this.notifyCheckoutListeners(directory, (ExtensionPointName<CheckoutListener>)CheckoutListener.EP_NAME);
        }
    }

    private static VirtualFile refreshVFS(final File directory) {
        final Ref result = new Ref();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                VirtualFile vDir = lfs.refreshAndFindFileByIoFile(directory);
                result.set((Object)vDir);
                if (vDir != null) {
                    LocalFileSystem.WatchRequest watchRequest = lfs.addRootToWatch(vDir.getPath(), true);
                    ((NewVirtualFile)vDir).markDirtyRecursively();
                    vDir.refresh(false, true);
                    if (watchRequest != null) {
                        lfs.removeWatchedRoot(watchRequest);
                    }
                }
            }
        });
        return (VirtualFile)result.get();
    }

    private void notifyCheckoutListeners(File directory, ExtensionPointName<CheckoutListener> epName) {
        CheckoutListener[] listeners;
        for (CheckoutListener listener : listeners = (CheckoutListener[])Extensions.getExtensions(epName)) {
            this.myFoundProject = listener.processCheckedOutDirectory(this.myProject, directory);
            if (this.myFoundProject) break;
        }
    }

    public void checkoutCompleted() {
        if (!this.myFoundProject && this.myFirstDirectory != null) {
            this.notifyCheckoutListeners(this.myFirstDirectory, (ExtensionPointName<CheckoutListener>)CheckoutListener.COMPLETED_EP_NAME);
        }
    }
}

