/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSelectFilesDialog<T>
extends DialogWrapper {
    protected ChangesTreeList<T> myFileList;
    protected JPanel myPanel;
    protected JCheckBox myDoNotShowCheckbox;
    protected final VcsShowConfirmationOption myConfirmationOption;

    public AbstractSelectFilesDialog(Project project, boolean canBeParent, VcsShowConfirmationOption confirmationOption, String prompt) {
        super(project, canBeParent);
        this.myConfirmationOption = confirmationOption;
        this.myPanel = new JPanel(new BorderLayout());
        if (prompt != null) {
            JLabel label = new JLabel(prompt);
            label.setUI((LabelUI)new MultiLineLabelUI());
            this.myPanel.add((Component)label, "North");
        }
        this.myDoNotShowCheckbox = new JCheckBox(CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]));
        this.myPanel.add((Component)this.myDoNotShowCheckbox, "South");
    }

    protected JComponent createNorthPanel() {
        AnAction[] actions;
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction action : actions = this.myFileList.getTreeActions()) {
            group.add(action);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    protected void doOKAction() {
        if (this.myDoNotShowCheckbox.isSelected()) {
            this.myConfirmationOption.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
        }
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFileList;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }
}

