/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.FileStatus;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class ShelvedBinaryFile
implements JDOMExternalizable {
    public String BEFORE_PATH;
    public String AFTER_PATH;
    @Nullable
    public String SHELVED_PATH;

    public ShelvedBinaryFile() {
    }

    public ShelvedBinaryFile(String beforePath, String afterPath, @Nullable String shelvedPath) {
        assert (beforePath != null || afterPath != null);
        this.BEFORE_PATH = beforePath;
        this.AFTER_PATH = afterPath;
        this.SHELVED_PATH = shelvedPath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public FileStatus getFileStatus() {
        if (this.BEFORE_PATH == null) {
            return FileStatus.ADDED;
        }
        if (this.SHELVED_PATH == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShelvedBinaryFile that = (ShelvedBinaryFile)o;
        if (this.AFTER_PATH != null ? !this.AFTER_PATH.equals(that.AFTER_PATH) : that.AFTER_PATH != null) {
            return false;
        }
        if (this.BEFORE_PATH != null ? !this.BEFORE_PATH.equals(that.BEFORE_PATH) : that.BEFORE_PATH != null) {
            return false;
        }
        return !(this.SHELVED_PATH != null ? !this.SHELVED_PATH.equals(that.SHELVED_PATH) : that.SHELVED_PATH != null);
    }

    public int hashCode() {
        int result = this.BEFORE_PATH != null ? this.BEFORE_PATH.hashCode() : 0;
        result = 31 * result + (this.AFTER_PATH != null ? this.AFTER_PATH.hashCode() : 0);
        result = 31 * result + (this.SHELVED_PATH != null ? this.SHELVED_PATH.hashCode() : 0);
        return result;
    }
}

