/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ReceivedChangeList
extends CommittedChangeListImpl {
    @NotNull
    private final CommittedChangeList myBaseList;
    private final int myBaseCount;
    private boolean myForcePartial;

    public ReceivedChangeList(@NotNull CommittedChangeList baseList) {
        if (baseList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/committed/ReceivedChangeList.<init> must not be null");
        }
        super(baseList.getName(), baseList.getComment(), baseList.getCommitterName(), baseList.getNumber(), baseList.getCommitDate(), Collections.emptyList());
        this.myBaseList = baseList;
        this.myBaseCount = baseList.getChanges().size();
        this.myForcePartial = false;
    }

    public void addChange(Change change) {
        this.myChanges.add(change);
    }

    public boolean isPartial() {
        return this.myForcePartial || this.myChanges.size() < this.myBaseCount;
    }

    public void setForcePartial(boolean forcePartial) {
        this.myForcePartial = forcePartial;
    }

    public AbstractVcs getVcs() {
        return this.myBaseList.getVcs();
    }

    @NotNull
    public CommittedChangeList getBaseList() {
        CommittedChangeList committedChangeList = this.myBaseList;
        if (committedChangeList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/ReceivedChangeList.getBaseList must not return null");
        }
        return committedChangeList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReceivedChangeList that = (ReceivedChangeList)((Object)o);
        return this.myBaseList.equals(that.myBaseList);
    }

    public int hashCode() {
        return this.myBaseList.hashCode();
    }

    static CommittedChangeList unwrap(CommittedChangeList changeList) {
        if (changeList instanceof ReceivedChangeList) {
            changeList = ((ReceivedChangeList)changeList).getBaseList();
        }
        return changeList;
    }

    public String toString() {
        return this.myBaseList.toString();
    }
}

