/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public ScheduleForAdditionAction() {
        super("Add to VCS", "Add to VCS", IconLoader.getIcon((String)"/actions/include.png"));
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        List files = (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        boolean bl = enabled = files != null && !files.isEmpty();
        if (!enabled) {
            DataContext dataContext = e.getDataContext();
            enabled = this.getUnversionedFile(dataContext) != null;
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        List<VirtualFile> files;
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        List<VirtualFile> unversionedFiles = (List<VirtualFile>)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        if (unversionedFiles == null || unversionedFiles.isEmpty()) {
            VirtualFile unversionedFile = this.getUnversionedFile(e.getDataContext());
            if (unversionedFile == null) {
                return;
            }
            files = Collections.singletonList(unversionedFile);
        } else {
            files = unversionedFiles;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        changeListManager.addUnversionedFiles(changeListManager.getDefaultChangeList(), files);
    }

    @Nullable
    private VirtualFile getUnversionedFile(DataContext dataContext) {
        VirtualFile file;
        if (dataContext == null) {
            return null;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        VirtualFile virtualFile = file = project == null ? null : (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file != null && FileStatusManager.getInstance((Project)project).getStatus(file) == FileStatus.UNKNOWN) {
            return file;
        }
        return null;
    }
}

