/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.FoldersCutDownWorker;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.LogicallyLockedHolder;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

class UpdatingChangeListBuilder
implements ChangelistBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder");
    private final ChangeListWorker myChangeListWorker;
    private final FileHolderComposite myComposite;
    private final Getter<Boolean> myDisposedGetter;
    private VcsDirtyScope myScope;
    private FoldersCutDownWorker myFoldersCutDownWorker;
    private final boolean myUpdateUnversioned;
    private final IgnoredFilesComponent myIgnoredFilesComponent;
    private final ExcludedFileIndex myIndex;
    private final ChangeListManagerGate myGate;

    UpdatingChangeListBuilder(ChangeListWorker changeListWorker, FileHolderComposite composite, Getter<Boolean> disposedGetter, boolean updateUnversioned, IgnoredFilesComponent ignoredFilesComponent, ChangeListManagerGate gate) {
        this.myChangeListWorker = changeListWorker;
        this.myComposite = composite;
        this.myDisposedGetter = disposedGetter;
        this.myUpdateUnversioned = updateUnversioned;
        this.myIgnoredFilesComponent = ignoredFilesComponent;
        this.myGate = gate;
        this.myIndex = ExcludedFileIndex.getInstance((Project)changeListWorker.getProject());
    }

    private void checkIfDisposed() {
        if (((Boolean)this.myDisposedGetter.get()).booleanValue()) {
            throw new ChangeListManagerImpl.DisposedException();
        }
    }

    public void setCurrent(VcsDirtyScope scope, FoldersCutDownWorker foldersWorker) {
        this.myScope = scope;
        this.myFoldersCutDownWorker = foldersWorker;
    }

    public void processChange(Change change, VcsKey vcsKey) {
        this.processChangeInList(change, (ChangeList)null, vcsKey);
    }

    public void processChangeInList(final Change change, final @Nullable ChangeList changeList, final VcsKey vcsKey) {
        this.checkIfDisposed();
        LOG.debug("[processChangeInList-1] entering, cl name: " + (changeList == null ? null : changeList.getName()) + " change: " + ChangesUtil.getFilePath((Change)change).getPath());
        String fileName = ChangesUtil.getFilePath((Change)change).getName();
        if (FileTypeManager.getInstance().isFileIgnored(fileName)) {
            LOG.debug("[processChangeInList-1] file type ignored");
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (ChangeListManagerImpl.isUnder(change, UpdatingChangeListBuilder.this.myScope)) {
                    if (changeList != null) {
                        LOG.debug("[processChangeInList-1] to add change to cl");
                        UpdatingChangeListBuilder.this.myChangeListWorker.addChangeToList(changeList.getName(), change, vcsKey);
                    } else {
                        LOG.debug("[processChangeInList-1] to add to corresponding list");
                        UpdatingChangeListBuilder.this.myChangeListWorker.addChangeToCorrespondingList(change, vcsKey);
                    }
                } else {
                    LOG.debug("[processChangeInList-1] not under scope");
                }
            }
        });
    }

    public void processChangeInList(Change change, String changeListName, VcsKey vcsKey) {
        this.checkIfDisposed();
        LocalChangeList list = null;
        if (changeListName != null && (list = this.myChangeListWorker.getCopyByName(changeListName)) == null) {
            list = this.myGate.addChangeList(changeListName, null);
        }
        this.processChangeInList(change, (ChangeList)list, vcsKey);
    }

    private boolean isExcluded(VirtualFile file) {
        return this.myIndex.isExcludedFile(file);
    }

    public void processUnversionedFile(VirtualFile file) {
        if (file == null || !this.myUpdateUnversioned) {
            return;
        }
        this.checkIfDisposed();
        if (this.isExcluded(file)) {
            return;
        }
        if (this.myScope.belongsTo((FilePath)new FilePathImpl(file))) {
            if (this.myIgnoredFilesComponent.isIgnoredFile(file)) {
                this.myComposite.getIgnoredFileHolder().addFile(file, "", false);
            } else if (!this.myComposite.getIgnoredFileHolder().containsFile(file)) {
                this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).addFile(file);
            }
            this.myChangeListWorker.removeSwitched(file);
        }
    }

    public void processLocallyDeletedFile(FilePath file) {
        this.processLocallyDeletedFile(new LocallyDeletedChange(file));
    }

    public void processLocallyDeletedFile(LocallyDeletedChange locallyDeletedChange) {
        if (!this.myUpdateUnversioned) {
            return;
        }
        this.checkIfDisposed();
        FilePath file = locallyDeletedChange.getPath();
        if (FileTypeManager.getInstance().isFileIgnored(file.getName())) {
            return;
        }
        if (this.myScope.belongsTo(file)) {
            this.myChangeListWorker.addLocallyDeleted(locallyDeletedChange);
        }
    }

    public void processModifiedWithoutCheckout(VirtualFile file) {
        if (file == null || !this.myUpdateUnversioned) {
            return;
        }
        this.checkIfDisposed();
        if (this.isExcluded(file)) {
            return;
        }
        if (this.myScope.belongsTo((FilePath)new FilePathImpl(file))) {
            this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).addFile(file);
        }
    }

    public void processIgnoredFile(VirtualFile file) {
        if (file == null || !this.myUpdateUnversioned) {
            return;
        }
        this.checkIfDisposed();
        if (this.isExcluded(file)) {
            return;
        }
        if (this.myScope.belongsTo((FilePath)new FilePathImpl(file))) {
            this.myComposite.getIgnoredFileHolder().addFile(file, "", false);
        }
    }

    public void processLockedFolder(VirtualFile file) {
        if (file == null) {
            return;
        }
        this.checkIfDisposed();
        if (this.myScope.belongsTo((FilePath)new FilePathImpl(file)) && this.myFoldersCutDownWorker.addCurrent(file)) {
            this.myComposite.getVFHolder(FileHolder.HolderType.LOCKED).addFile(file);
        }
    }

    public void processLogicallyLockedFolder(VirtualFile file, LogicalLock logicalLock) {
        if (file == null) {
            return;
        }
        this.checkIfDisposed();
        if (this.myScope.belongsTo((FilePath)new FilePathImpl(file))) {
            ((LogicallyLockedHolder)this.myComposite.get(FileHolder.HolderType.LOGICALLY_LOCKED)).add(file, logicalLock);
        }
    }

    public void processSwitchedFile(VirtualFile file, String branch, boolean recursive) {
        if (file == null || !this.myUpdateUnversioned) {
            return;
        }
        this.checkIfDisposed();
        if (this.isExcluded(file)) {
            return;
        }
        if (this.myScope.belongsTo((FilePath)new FilePathImpl(file))) {
            this.myChangeListWorker.addSwitched(file, branch, recursive);
        }
    }

    public void processRootSwitch(VirtualFile file, String branch) {
        if (file == null) {
            return;
        }
        this.checkIfDisposed();
        if (this.myScope.belongsTo((FilePath)new FilePathImpl(file))) {
            ((SwitchedFileHolder)this.myComposite.get(FileHolder.HolderType.ROOT_SWITCH)).addFile(file, branch, false);
        }
    }

    public boolean isUpdatingUnversionedFiles() {
        return this.myUpdateUnversioned;
    }

    public boolean reportChangesOutsideProject() {
        return false;
    }
}

