/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.CallbackData;
import com.intellij.openapi.vcs.changes.ExecutorWrapper;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangesUpdater;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerProxy;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class UpdateRequestsQueue {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.UpdateRequestsQueue");
    private final Project myProject;
    private final ScheduledExecutorService myExecutor;
    private final LocalChangesUpdater myDelegate;
    private final Object myLock;
    private volatile boolean myStarted;
    private volatile boolean myStopped;
    private boolean myRequestSubmitted;
    private final List<Runnable> myWaitingUpdateCompletionQueue;
    private final ProjectLevelVcsManager myPlVcsManager;
    private boolean myUpdateUnversionedRequested;
    private final StartupManager myStartupManager;
    private final ExecutorWrapper myExecutorWrapper;
    @NonNls
    public static final String LOCAL_CHANGES_UPDATE = "Local changes update";

    public UpdateRequestsQueue(Project project, ScheduledExecutorService executor, LocalChangesUpdater delegate) {
        this.myProject = project;
        this.myExecutor = executor;
        this.myExecutorWrapper = new ExecutorWrapper(this.myProject, LOCAL_CHANGES_UPDATE);
        this.myDelegate = delegate;
        this.myPlVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myStartupManager = StartupManager.getInstance((Project)this.myProject);
        this.myLock = new Object();
        this.myWaitingUpdateCompletionQueue = new ArrayList<Runnable>();
        this.myStarted = false;
        this.myStopped = false;
        this.myUpdateUnversionedRequested = false;
    }

    public void initialized() {
        this.LOG.debug("Initialized for project: " + this.myProject.getName());
        this.myStarted = true;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(boolean updateUnversionedFiles) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myStarted && ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (!this.myStopped) {
                if (!this.myRequestSubmitted) {
                    MyRunnable runnable = new MyRunnable();
                    this.myRequestSubmitted = true;
                    this.myExecutor.schedule(runnable, 300L, TimeUnit.MILLISECONDS);
                    this.LOG.debug("Scheduled for project: " + this.myProject.getName() + ", runnable: " + runnable.hashCode());
                    this.myUpdateUnversionedRequested |= updateUnversionedFiles;
                } else if (updateUnversionedFiles && !this.myUpdateUnversionedRequested) {
                    this.myUpdateUnversionedRequested = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.LOG.debug("Calling stop for project: " + this.myProject.getName());
        ArrayList<Runnable> waiters = new ArrayList<Runnable>(this.myWaitingUpdateCompletionQueue.size());
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = true;
            waiters.addAll(this.myWaitingUpdateCompletionQueue);
            this.myWaitingUpdateCompletionQueue.clear();
        }
        this.LOG.debug("Calling runnables in stop for project: " + this.myProject.getName());
        for (Runnable runnable : waiters) {
            runnable.run();
        }
        this.LOG.debug("Stop finished for project: " + this.myProject.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAfterUpdate(final Runnable afterUpdate, InvokeAfterUpdateMode mode, String title, Consumer<VcsDirtyScopeManager> dirtyScopeManagerFiller, ModalityState state) {
        this.LOG.debug("invokeAfterUpdate for project: " + this.myProject.getName());
        CallbackData data = CallbackData.create(afterUpdate, title, state, mode, this.myProject);
        VcsDirtyScopeManagerProxy managerProxy = null;
        if (dirtyScopeManagerFiller != null) {
            managerProxy = new VcsDirtyScopeManagerProxy();
            dirtyScopeManagerFiller.consume((Object)managerProxy);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myStopped) {
                if (managerProxy != null) {
                    managerProxy.callRealManager(VcsDirtyScopeManager.getInstance((Project)this.myProject));
                }
                this.myWaitingUpdateCompletionQueue.add(data.getCallback());
                this.schedule(true);
            }
        }
        if (this.myStopped) {
            this.LOG.debug("invokeAfterUpdate: stopped, invoke right now for project: " + this.myProject.getName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    afterUpdate.run();
                }
            });
            return;
        }
        if (data.getWrapperStarter() != null) {
            data.getWrapperStarter().run();
        }
        this.LOG.debug("invokeAfterUpdate: exit for project: " + this.myProject.getName());
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            ArrayList copy;
            block25: {
                copy = new ArrayList(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.size());
                object = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object
                if ((UpdateRequestsQueue.this.myStopped || UpdateRequestsQueue.this.myStarted && !UpdateRequestsQueue.this.myPlVcsManager.isBackgroundVcsOperationRunning()) && ((StartupManagerImpl)UpdateRequestsQueue.this.myStartupManager).startupActivityPassed()) break block25;
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: not started, not stopped, reschedule, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                UpdateRequestsQueue.this.myRequestSubmitted = false;
                UpdateRequestsQueue.this.schedule(UpdateRequestsQueue.this.myUpdateUnversionedRequested);
                // MONITOREXIT : object
                Object object2 = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object2
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: delete executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                if (!copy.isEmpty()) {
                    UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.removeAll(copy);
                }
                if (!UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() && !UpdateRequestsQueue.this.myRequestSubmitted) {
                    UpdateRequestsQueue.this.LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : object2
                Iterator i$ = copy.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        UpdateRequestsQueue.this.LOG.debug("MyRunnable: Runnables executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                        return;
                    }
                    Runnable runnable = (Runnable)i$.next();
                    runnable.run();
                }
            }
            copy.addAll(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue);
            UpdateRequestsQueue.this.myRequestSubmitted = false;
            if (UpdateRequestsQueue.this.myStopped) {
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: STOPPED, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                // MONITOREXIT : object
                Iterator i$ = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : i$
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: delete executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                if (!copy.isEmpty()) {
                    UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.removeAll(copy);
                }
                if (!UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() && !UpdateRequestsQueue.this.myRequestSubmitted) {
                    UpdateRequestsQueue.this.LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : i$
                i$ = copy.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        UpdateRequestsQueue.this.LOG.debug("MyRunnable: Runnables executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                        return;
                    }
                    Runnable runnable = (Runnable)i$.next();
                    runnable.run();
                }
            }
            try {
                final boolean updateUnversioned = UpdateRequestsQueue.this.myUpdateUnversionedRequested;
                UpdateRequestsQueue.this.myUpdateUnversionedRequested = false;
                // MONITOREXIT : object
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: INVOKE, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                UpdateRequestsQueue.this.myExecutorWrapper.submit(new Consumer<AtomicSectionsAware>(){

                    public void consume(AtomicSectionsAware atomicSectionsAware) {
                        UpdateRequestsQueue.this.myDelegate.execute(updateUnversioned, atomicSectionsAware);
                    }
                });
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: invokeD, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                object = UpdateRequestsQueue.this.myLock;
            }
        }
    }
}

