/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LibraryConfigurable
extends ProjectStructureElementConfigurable<Library> {
    private static final Icon ICON = IconLoader.getIcon((String)"/modules/library.png");
    private LibraryTableEditor myLibraryEditor;
    private final Library myLibrary;
    private final LibraryTableModifiableModelProvider myModel;
    private final Project myProject;
    private final LibraryProjectStructureElement myProjectStructureElement;
    private boolean myUpdatingName;

    protected LibraryConfigurable(LibraryTableModifiableModelProvider libraryTable, Library library, Project project, Runnable updateTree) {
        super(true, updateTree);
        this.myModel = libraryTable;
        this.myProject = project;
        this.myLibrary = library;
        StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(this.myProject).getContext();
        this.myProjectStructureElement = new LibraryProjectStructureElement(context, this.myLibrary);
    }

    public JComponent createOptionsPanel() {
        this.myLibraryEditor = LibraryTableEditor.editLibrary(this.myModel, this.myLibrary, this.myProject);
        final StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(this.myProject).getContext();
        this.myLibraryEditor.addLibraryEditorListener(context);
        this.myLibraryEditor.addListener(new Runnable(){

            @Override
            public void run() {
                context.getDaemonAnalyzer().queueUpdate(LibraryConfigurable.this.myProjectStructureElement);
            }
        });
        return this.myLibraryEditor.getComponent();
    }

    public boolean isModified() {
        return this.myLibraryEditor != null && this.myLibraryEditor.hasChanges();
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void disposeUIResources() {
        if (this.myLibraryEditor != null) {
            this.myLibraryEditor.cancelChanges();
            Disposer.dispose((Disposable)this.myLibraryEditor);
            this.myLibraryEditor = null;
        }
    }

    public void setDisplayName(String name) {
        if (!this.myUpdatingName) {
            this.getLibraryEditor().setName(name);
        }
    }

    private LibraryEditor getLibraryEditor() {
        return ((LibrariesModifiableModel)this.myModel.getModifiableModel()).getLibraryEditor(this.myLibrary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateName() {
        this.myUpdatingName = true;
        try {
            super.updateName();
        }
        finally {
            this.myUpdatingName = false;
        }
    }

    public Library getEditableObject() {
        return this.myLibrary;
    }

    public String getBannerSlogan() {
        LibraryTable libraryTable = this.myLibrary.getTable();
        String libraryType = libraryTable == null ? ProjectBundle.message((String)"module.library.display.name", (Object[])new Object[]{1}) : libraryTable.getPresentation().getDisplayName(false);
        return ProjectBundle.message((String)"project.roots.library.banner.text", (Object[])new Object[]{this.getDisplayName(), libraryType});
    }

    public String getDisplayName() {
        return this.getLibraryEditor().getName();
    }

    public Icon getIcon() {
        return ICON;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.jdkGlobalLibs";
    }
}

