/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManager;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManagerImpl;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.facet.impl.ui.facetType.FacetTypeEditor;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetEditorFacadeImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetTypeConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.IconLoader;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FacetStructureConfigurable.UI", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class FacetStructureConfigurable
extends BaseStructureConfigurable {
    private static final Icon ICON = IconLoader.getIcon((String)"/modules/modules.png");
    private final ModuleManager myModuleManager;
    private final Map<FacetType<?, ?>, FacetTypeEditor> myFacetTypeEditors = new HashMap();
    private MultipleFacetSettingsEditor myCurrentMultipleSettingsEditor;

    public FacetStructureConfigurable(Project project, ModuleManager moduleManager) {
        super(project);
        this.myModuleManager = moduleManager;
    }

    public static FacetStructureConfigurable getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable.getInstance must not be null");
        }
        return (FacetStructureConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, FacetStructureConfigurable.class);
    }

    public static boolean isEnabled() {
        return FacetTypeRegistry.getInstance().getFacetTypes().length > 0;
    }

    @Override
    protected void loadTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        for (FacetType facetType : FacetTypeRegistry.getInstance().getFacetTypes()) {
            FacetTypeConfigurable facetTypeConfigurable = new FacetTypeConfigurable(this, facetType);
            MasterDetailsComponent.MyNode facetTypeNode = new MasterDetailsComponent.MyNode((NamedConfigurable)facetTypeConfigurable);
            this.addNode(facetTypeNode, this.myRoot);
            for (Module module : this.myModuleManager.getModules()) {
                Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(facetType.getId());
                for (Facet facet : facets) {
                    FacetEditorFacadeImpl editorFacade = ModuleStructureConfigurable.getInstance(this.myProject).getFacetEditorFacade();
                    FacetConfigurable facetConfigurable = editorFacade.getOrCreateConfigurable(facet);
                    this.addNode(new FacetConfigurableNode(facetConfigurable), facetTypeNode);
                }
            }
        }
    }

    @Nullable
    public FacetTypeEditor getFacetTypeEditor(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable.getFacetTypeEditor must not be null");
        }
        return this.myFacetTypeEditors.get(facetType);
    }

    public FacetTypeEditor getOrCreateFacetTypeEditor(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable.getOrCreateFacetTypeEditor must not be null");
        }
        FacetTypeEditor editor = this.myFacetTypeEditors.get(facetType);
        if (editor == null) {
            editor = new FacetTypeEditor(this.myProject, this.myContext, facetType);
            editor.reset();
            this.myFacetTypeEditors.put(facetType, editor);
        }
        return editor;
    }

    @Override
    public void reset() {
        super.reset();
        this.myFacetTypeEditors.clear();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        for (FacetTypeEditor editor : this.myFacetTypeEditors.values()) {
            editor.apply();
        }
        if (!this.myProject.isDefault()) {
            ((FacetAutodetectingManagerImpl)FacetAutodetectingManager.getInstance(this.myProject)).redetectFacets();
        }
    }

    public boolean isModified() {
        return super.isModified() || this.isEditorsModified();
    }

    private boolean isEditorsModified() {
        for (FacetTypeEditor editor : this.myFacetTypeEditors.values()) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        for (FacetTypeEditor editor : this.myFacetTypeEditors.values()) {
            editor.disposeUIResources();
        }
        this.myFacetTypeEditors.clear();
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (fromPopup) {
            actions.add(new MyNavigateAction());
        }
        actions.add((AnAction)new BaseStructureConfigurable.MyRemoveAction());
        actions.add((AnAction)Separator.getInstance());
        this.addCollapseExpandActions(actions);
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable.createActions must not return null");
        }
        return arrayList;
    }

    @Override
    protected List<Facet> removeFacet(Facet facet) {
        List<Facet> removed = super.removeFacet(facet);
        ModuleStructureConfigurable.getInstance(this.myProject).removeFacetNodes(removed);
        return removed;
    }

    protected boolean updateMultiSelection(List<NamedConfigurable> selectedConfigurables) {
        return this.updateMultiSelection(selectedConfigurables, this.getDetailsComponent());
    }

    public boolean updateMultiSelection(List<NamedConfigurable> selectedConfigurables, DetailsComponent detailsComponent) {
        FacetType selectedFacetType = null;
        ArrayList<FacetEditorImpl> facetEditors = new ArrayList<FacetEditorImpl>();
        for (NamedConfigurable selectedConfigurable : selectedConfigurables) {
            if (!(selectedConfigurable instanceof FacetConfigurable)) continue;
            FacetConfigurable facetConfigurable = (FacetConfigurable)selectedConfigurable;
            FacetType facetType = facetConfigurable.getEditableObject().getType();
            if (selectedFacetType != null && selectedFacetType != facetType) {
                return false;
            }
            selectedFacetType = facetType;
            facetEditors.add(facetConfigurable.getEditor());
        }
        if (facetEditors.size() <= 1 || selectedFacetType == null) {
            return false;
        }
        FacetEditor[] selectedEditors = facetEditors.toArray(new FacetEditor[facetEditors.size()]);
        MultipleFacetSettingsEditor editor = selectedFacetType.createMultipleConfigurationsEditor(this.myProject, selectedEditors);
        if (editor == null) {
            return false;
        }
        this.setSelectedNode(null);
        this.myCurrentMultipleSettingsEditor = editor;
        detailsComponent.setText(new String[]{ProjectBundle.message((String)"multiple.facets.banner.0.1.facets", (Object[])new Object[]{selectedEditors.length, selectedFacetType.getPresentableName()})});
        detailsComponent.setContent(editor.createComponent());
        return true;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        this.disposeMultipleSettingsEditor();
        if (configurable instanceof FacetTypeConfigurable) {
            ((FacetTypeConfigurable)configurable).updateComponent();
        }
        super.updateSelection(configurable);
    }

    public void disposeMultipleSettingsEditor() {
        if (this.myCurrentMultipleSettingsEditor != null) {
            this.myCurrentMultipleSettingsEditor.disposeUIResources();
            this.myCurrentMultipleSettingsEditor = null;
        }
    }

    @Override
    @Nullable
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return null;
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.facets.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getHelpTopic() {
        String topic;
        FacetType facetType;
        String topic2;
        NamedConfigurable selectedConfugurable;
        Component component = (Component)DataKeys.CONTEXT_COMPONENT.getData(DataManager.getInstance().getDataContext());
        if (this.myTree.equals(component) && (selectedConfugurable = this.getSelectedConfugurable()) instanceof FacetTypeConfigurable && (topic2 = (facetType = ((FacetTypeConfigurable)selectedConfugurable).getEditableObject()).getHelpTopic()) != null) {
            return topic2;
        }
        if (this.myCurrentMultipleSettingsEditor != null && (topic = this.myCurrentMultipleSettingsEditor.getHelpTopic()) != null) {
            return topic;
        }
        topic = super.getHelpTopic();
        if (topic != null) {
            return topic;
        }
        return "reference.settingsdialog.project.structure.facet";
    }

    public String getId() {
        return "project.facets";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public void dispose() {
    }

    private class MyNavigateAction
    extends AnAction
    implements DumbAware {
        private MyNavigateAction() {
            super(ProjectBundle.message((String)"action.name.facet.navigate", (Object[])new Object[0]));
            this.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)FacetStructureConfigurable.this.myTree);
        }

        public void update(AnActionEvent e) {
            NamedConfigurable selected = FacetStructureConfigurable.this.getSelectedConfugurable();
            e.getPresentation().setEnabled(selected instanceof FacetConfigurable);
        }

        public void actionPerformed(AnActionEvent e) {
            NamedConfigurable selected = FacetStructureConfigurable.this.getSelectedConfugurable();
            if (selected instanceof FacetConfigurable) {
                ProjectStructureConfigurable.getInstance(FacetStructureConfigurable.this.myProject).select(((FacetConfigurable)selected).getEditableObject(), true);
            }
        }
    }

    private class FacetConfigurableNode
    extends MasterDetailsComponent.MyNode {
        public FacetConfigurableNode(FacetConfigurable facetConfigurable) {
            super((NamedConfigurable)facetConfigurable);
        }

        @NotNull
        public String getDisplayName() {
            FacetConfigurable facetConfigurable = (FacetConfigurable)this.getConfigurable();
            String moduleName = FacetStructureConfigurable.this.myContext.getRealName(facetConfigurable.getEditableObject().getModule());
            String string = facetConfigurable.getDisplayName() + " (" + moduleName + ")";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable$FacetConfigurableNode.getDisplayName must not return null");
            }
            return string;
        }
    }
}

