/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutIntoDefaultLocationActionBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.HashSet;
import java.util.List;

public class PutSourceItemIntoDefaultLocationAction
extends PutIntoDefaultLocationActionBase {
    public PutSourceItemIntoDefaultLocationAction(SourceItemsTree sourceItemsTree, ArtifactEditorEx artifactEditor) {
        super(sourceItemsTree, artifactEditor);
    }

    public void update(AnActionEvent e) {
        List<PackagingSourceItem> items = this.mySourceItemsTree.getSelectedItems();
        boolean enabled = false;
        Presentation presentation = e.getPresentation();
        if (!items.isEmpty()) {
            enabled = true;
            HashSet<String> paths = new HashSet<String>();
            for (PackagingSourceItem item : items) {
                String path = this.getDefaultPath(item);
                if (path == null) {
                    enabled = false;
                    break;
                }
                paths.add(StringUtil.trimStart((String)StringUtil.trimEnd((String)path, (String)"/"), (String)"/"));
            }
            if (paths.size() == 1) {
                presentation.setText("Put Into /" + (String)paths.iterator().next());
            } else {
                presentation.setText("Put into default locations");
            }
        }
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        this.myArtifactEditor.getLayoutTreeComponent().putIntoDefaultLocations(this.mySourceItemsTree.getSelectedItems());
    }
}

