/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleGroupItem
extends PackagingSourceItem {
    private final String myGroupName;
    private final String[] myPath;

    public ModuleGroupItem(String[] path) {
        super(false);
        this.myGroupName = path[path.length - 1];
        this.myPath = path;
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleGroupItem && Comparing.equal((Object[])this.myPath, (Object[])((ModuleGroupItem)((Object)obj)).myPath);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myPath);
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleGroupItem.createPresentation must not be null");
        }
        return new ModuleGroupSourceItemPresentation(this.myGroupName);
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleGroupItem.createElements must not be null");
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleGroupItem.createElements must not return null");
        }
        return list;
    }

    public String[] getPath() {
        return this.myPath;
    }

    private static class ModuleGroupSourceItemPresentation
    extends SourceItemPresentation {
        private final String myGroupName;

        public ModuleGroupSourceItemPresentation(String groupName) {
            this.myGroupName = groupName;
        }

        public String getPresentableName() {
            return this.myGroupName;
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            if (presentationData == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleGroupItem$ModuleGroupSourceItemPresentation.render must not be null");
            }
            presentationData.setClosedIcon(Icons.CLOSED_MODULE_GROUP_ICON);
            presentationData.setOpenIcon(Icons.OPENED_MODULE_GROUP_ICON);
            presentationData.addText(this.myGroupName, mainAttributes);
        }

        public int getWeight() {
            return 100;
        }
    }
}

