/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.AbstractSchemesManager;
import com.intellij.openapi.options.CurrentUserHolder;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManagerFactoryImpl;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.UniqueFileNamesProvider;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends AbstractSchemesManager<T, E> {
    private static final Logger LOG = Logger.getInstance((String)("#" + SchemesManagerFactoryImpl.class.getName()));
    private static final String EXT = ".xml";
    private final Set<String> myDeletedNames = new LinkedHashSet<String>();
    private final Set<String> myFilesToDelete = new HashSet();
    private static final String SHARED_SCHEME = "shared-scheme";
    private static final String SHARED_SCHEME_ORIGINAL = "shared-scheme-original";
    private static final String NAME = "name";
    private static final String ORIGINAL_SCHEME_PATH = "original-scheme-path";
    private final String myFileSpec;
    private final SchemeProcessor<E> myProcessor;
    private final RoamingType myRoamingType;
    private static final String SCHEME_LOCAL_COPY = "scheme-local-copy";
    private static final String DELETED_XML = "__deleted.xml";
    private final StreamProvider[] myProviders;
    private final File myBaseDir;
    private VirtualFile myVFSBaseDir;
    private static final String DESCRIPTION = "description";
    private static final boolean EXPORT_IS_AVAILABLE = false;
    private static final String USER = "user";
    private boolean myListenerAdded = false;
    private Alarm myRefreshAlarm;
    private boolean myInsideSave = false;

    public SchemesManagerImpl(String fileSpec, SchemeProcessor<E> processor, RoamingType roamingType, StreamProvider[] providers, File baseDir) {
        this.myFileSpec = fileSpec;
        this.myProcessor = processor;
        this.myRoamingType = roamingType;
        this.myProviders = providers;
        this.myBaseDir = baseDir;
        this.myBaseDir.mkdirs();
        if (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isCommandLine()) {
            this.addVFSListener();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<E> loadSchemes() {
        Collection<Object> collection;
        if (this.myVFSBaseDir != null) {
            collection = this.doLoad();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/options/SchemesManagerImpl.loadSchemes must not return null");
            return collection;
        }
        collection = Collections.emptyList();
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/options/SchemesManagerImpl.loadSchemes must not return null");
    }

    private Collection<E> doLoad() {
        this.myDeletedNames.addAll(this.readDeletedSchemeNames());
        LinkedHashMap<String, ExternalizableScheme> read = new LinkedHashMap<String, ExternalizableScheme>();
        for (ExternalizableScheme e : this.readSchemesFromFileSystem()) {
            read.put(e.getName(), e);
        }
        for (ExternalizableScheme e : this.readSchemesFromProviders()) {
            read.put(e.getName(), e);
        }
        Collection result = read.values();
        this.initLoadedSchemes(result);
        return result;
    }

    private void addVFSListener() {
        Application app = ApplicationManager.getApplication();
        if (app == null || this.myListenerAdded) {
            return;
        }
        LocalFileSystem system = LocalFileSystem.getInstance();
        this.myVFSBaseDir = system.findFileByIoFile(this.myBaseDir);
        if (this.myVFSBaseDir == null && !app.isUnitTestMode() && !app.isHeadlessEnvironment()) {
            this.myRefreshAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            this.myRefreshAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    SchemesManagerImpl.this.ensureVFSBaseDir();
                }
            }, 60000, ModalityState.NON_MODAL);
        }
        system.addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void contentsChanged(VirtualFileEvent event) {
                SchemesManagerImpl.this.onFileContentChanged(event);
            }

            public void fileCreated(VirtualFileEvent event) {
                VirtualFile file = event.getFile();
                if (event.getRequestor() == null && SchemesManagerImpl.this.isFileUnder(file, SchemesManagerImpl.this.myVFSBaseDir) && !SchemesManagerImpl.this.myInsideSave) {
                    ArrayList read = new ArrayList();
                    SchemesManagerImpl.this.readSchemeFromFile(read, file, true);
                    if (!read.isEmpty()) {
                        ExternalizableScheme readScheme = (ExternalizableScheme)read.get(0);
                        SchemesManagerImpl.this.myProcessor.initScheme(readScheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeAdded(readScheme);
                    }
                }
            }

            public void fileDeleted(VirtualFileEvent event) {
                VirtualFile parent = event.getParent();
                if (event.getRequestor() == null && parent != null && parent.equals(SchemesManagerImpl.this.myVFSBaseDir) && !SchemesManagerImpl.this.myInsideSave) {
                    File ioFile = new File(event.getFileName());
                    ExternalizableScheme scheme = SchemesManagerImpl.this.findSchemeFor(ioFile.getName());
                    Scheme oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = (Scheme)SchemesManagerImpl.this.getCurrentScheme();
                        SchemesManagerImpl.this.removeScheme(scheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeDeleted(scheme);
                    }
                    Object newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                    if (oldCurrentScheme != null && newCurrentScheme == null && !SchemesManagerImpl.this.mySchemes.isEmpty()) {
                        SchemesManagerImpl.this.setCurrentSchemeName(((Scheme)SchemesManagerImpl.this.mySchemes.get(0)).getName());
                        newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                    }
                    if (oldCurrentScheme != newCurrentScheme) {
                        SchemesManagerImpl.this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                    }
                }
            }
        });
        this.myListenerAdded = true;
    }

    private void onFileContentChanged(VirtualFileEvent event) {
        VirtualFile file = event.getFile();
        if (event.getRequestor() == null && this.isFileUnder(file, this.myVFSBaseDir) && !this.myInsideSave) {
            File ioFile = new File(file.getPath());
            E scheme = this.findSchemeFor(ioFile.getName());
            ArrayList read = new ArrayList();
            Scheme oldCurrentScheme = null;
            if (scheme != null) {
                oldCurrentScheme = (Scheme)this.getCurrentScheme();
                this.removeScheme(scheme);
                this.myProcessor.onSchemeDeleted(scheme);
            }
            this.readSchemeFromFile(read, file, true);
            if (!read.isEmpty()) {
                ExternalizableScheme readScheme = (ExternalizableScheme)read.get(0);
                this.myProcessor.initScheme(readScheme);
                this.myProcessor.onSchemeAdded(readScheme);
                Object newCurrentScheme = this.getCurrentScheme();
                if (oldCurrentScheme != null && newCurrentScheme == null) {
                    this.setCurrentSchemeName(readScheme.getName());
                    newCurrentScheme = this.getCurrentScheme();
                }
                if (oldCurrentScheme != newCurrentScheme) {
                    this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                }
            }
        }
    }

    private E findSchemeFor(String ioFileName) {
        for (Scheme scheme : this.mySchemes) {
            String fileName;
            if (!(scheme instanceof ExternalizableScheme) || !ioFileName.equals((fileName = ((ExternalizableScheme)scheme).getExternalInfo().getCurrentFileName()) + EXT)) continue;
            return (E)((ExternalizableScheme)scheme);
        }
        return null;
    }

    private boolean isFileUnder(VirtualFile file, VirtualFile baseDirFile) {
        return file.getParent().equals(baseDirFile);
    }

    private Collection<String> readDeletedSchemeNames() {
        HashSet result = new HashSet();
        for (StreamProvider provider : this.getEnabledProviders()) {
            try {
                Document deletedNameDoc = StorageUtil.loadDocument(provider.loadContent(this.getFileFullPath(DELETED_XML), this.myRoamingType));
                if (deletedNameDoc == null) continue;
                for (Object child : deletedNameDoc.getRootElement().getChildren()) {
                    String deletedSchemeName = ((Element)child).getAttributeValue(NAME);
                    if (deletedSchemeName == null) continue;
                    result.add(deletedSchemeName);
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
        return result;
    }

    private void initLoadedSchemes(Collection<E> read) {
        for (ExternalizableScheme scheme : read) {
            this.myProcessor.initScheme(scheme);
            this.checkCurrentScheme((Scheme)scheme);
        }
    }

    private Collection<E> readSchemesFromProviders() {
        ArrayList<E> result = new ArrayList<E>();
        for (StreamProvider provider : this.getEnabledProviders()) {
            String[] paths;
            for (String subpath : paths = provider.listSubFiles(this.myFileSpec)) {
                if (subpath.equals(DELETED_XML)) continue;
                try {
                    String currentFileName;
                    Document subDocument = StorageUtil.loadDocument(provider.loadContent(this.getFileFullPath(subpath), this.myRoamingType));
                    if (subDocument == null) continue;
                    E scheme = this.readScheme(subDocument);
                    boolean fileRenamed = false;
                    Object existing = this.findSchemeByName(scheme.getName());
                    if (existing != null && existing instanceof ExternalizableScheme && (currentFileName = ((ExternalizableScheme)existing).getExternalInfo().getCurrentFileName()) != null && !currentFileName.equals(subpath)) {
                        this.deleteServerFiles(subpath);
                        subpath = currentFileName;
                        fileRenamed = true;
                    }
                    String fileName = this.checkFileNameIsFree(subpath, scheme.getName());
                    if (!fileRenamed && !fileName.equals(subpath)) {
                        this.deleteServerFiles(subpath);
                    }
                    if (scheme == null) continue;
                    this.loadScheme(scheme, false, fileName);
                    result.add(scheme);
                }
                catch (Exception e) {
                    LOG.info("Cannot load data from IDEAServer: " + e.getLocalizedMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualFile ensureFileText(String fileName, byte[] text) throws IOException {
        VirtualFile file = this.myVFSBaseDir.findChild(fileName);
        if (file == null) {
            file = this.myVFSBaseDir.createChildData((Object)this, fileName);
        }
        if (!Arrays.equals(file.contentsToByteArray(), text)) {
            OutputStream output = file.getOutputStream((Object)this);
            try {
                output.write(text);
            }
            finally {
                output.close();
            }
        }
        return file;
    }

    private String checkFileNameIsFree(String subpath, String schemeName) throws IOException {
        for (Scheme scheme : this.mySchemes) {
            String fileName;
            ExternalInfo externalInfo;
            String name;
            if (!(scheme instanceof ExternalizableScheme) || (name = (externalInfo = ((ExternalizableScheme)scheme).getExternalInfo()).getCurrentFileName()) == null || !(fileName = name + EXT).equals(subpath) || Comparing.equal((String)schemeName, (String)scheme.getName())) continue;
            return this.createUniqueFileName(this.collectAllFileNames(), UniqueFileNamesProvider.convertName((String)schemeName));
        }
        return subpath;
    }

    private Collection<String> collectAllFileNames() {
        HashSet result = new HashSet();
        for (Scheme scheme : this.mySchemes) {
            ExternalInfo externalInfo;
            if (!(scheme instanceof ExternalizableScheme) || (externalInfo = ((ExternalizableScheme)scheme).getExternalInfo()).getCurrentFileName() == null) continue;
            result.add((Object)externalInfo.getCurrentFileName());
        }
        return result;
    }

    private String createUniqueFileName(Collection<String> strings, String schemeName) {
        return UniqueNameGenerator.generateUniqueName((String)schemeName, (String)"", (String)"", strings);
    }

    private void loadScheme(E scheme, boolean forceAdd, String name) throws IOException {
        if (scheme != null && (!this.myDeletedNames.contains(scheme.getName()) || forceAdd)) {
            Object existing = this.findSchemeByName(scheme.getName());
            if (existing != null) {
                this.mySchemes.remove(existing);
                if (this.isExternalizable(existing)) {
                    this.myProcessor.onSchemeDeleted((ExternalizableScheme)existing);
                }
            }
            this.addNewScheme(scheme, true);
            this.saveFileName(name, scheme);
            scheme.getExternalInfo().setPreviouslySavedName(scheme.getName());
        }
    }

    private Collection<E> readSchemesFromFileSystem() {
        ArrayList result = new ArrayList();
        VirtualFile[] files = this.myVFSBaseDir.getChildren();
        if (files != null) {
            for (VirtualFile file : files) {
                this.readSchemeFromFile(result, file, false);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String msg = "Cannot read directory: " + SchemesManagerImpl.this.myBaseDir.getAbsolutePath() + " directory does not exist";
                    Messages.showErrorDialog((String)msg, (String)"Read Settings");
                }
            });
        }
        return result;
    }

    private void readSchemeFromFile(Collection<E> result, final VirtualFile file, boolean forceAdd) {
        String name = file.getName();
        if (!file.isDirectory() && StringUtil.endsWithIgnoreCase((String)name, (String)EXT)) {
            try {
                Document document;
                try {
                    document = JDOMUtil.loadDocument((InputStream)file.getInputStream());
                }
                catch (JDOMException e) {
                    try {
                        File initialIOFile = new File(this.myBaseDir, file.getName());
                        if (initialIOFile.isFile()) {
                            FileUtil.copy((File)initialIOFile, (File)new File(this.myBaseDir, file.getName() + ".copy"));
                        }
                    }
                    catch (IOException e1) {
                        LOG.info((Throwable)e1);
                    }
                    LOG.info("Error reading file " + file.getPath() + ": " + e.getLocalizedMessage());
                    throw e;
                }
                E scheme = this.readScheme(document);
                if (scheme != null) {
                    String suggestedName;
                    if (scheme.getName() == null && !"_".equals(suggestedName = FileUtil.getNameWithoutExtension((String)file.getName()))) {
                        scheme.setName(suggestedName);
                    }
                    this.loadScheme(scheme, forceAdd, file.getName());
                    result.add(scheme);
                }
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String msg = "Cannot read scheme " + file.getName() + "  from '" + SchemesManagerImpl.this.myFileSpec + "': " + e.getLocalizedMessage();
                        LOG.info(msg, (Throwable)e);
                        Messages.showErrorDialog((String)msg, (String)"Load Settings");
                    }
                });
            }
        }
    }

    @Nullable
    private E readScheme(Document subDocument) throws InvalidDataException, IOException, JDOMException {
        Element rootElement = subDocument.getRootElement();
        if (rootElement.getName().equals(SHARED_SCHEME)) {
            String schemeName = rootElement.getAttributeValue(NAME);
            String schemePath = rootElement.getAttributeValue(ORIGINAL_SCHEME_PATH);
            Document sharedDocument = SchemesManagerImpl.loadGlobalScheme(schemePath);
            if (sharedDocument != null) {
                E result = this.readScheme(sharedDocument);
                if (result != null) {
                    this.renameScheme(result, schemeName);
                    result.getExternalInfo().setOriginalPath(schemePath);
                    result.getExternalInfo().setIsImported(true);
                }
                return result;
            }
            Element localCopyElement = subDocument.getRootElement().getChild(SCHEME_LOCAL_COPY);
            if (localCopyElement != null) {
                Element firstChild = (Element)localCopyElement.getChildren().get(0);
                return (E)this.myProcessor.readScheme(new Document((Element)firstChild.clone()));
            }
            return null;
        }
        if (rootElement.getName().equals(SHARED_SCHEME_ORIGINAL)) {
            SharedSchemeData schemeData = this.unwrap(subDocument);
            ExternalizableScheme scheme = this.myProcessor.readScheme(schemeData.original);
            if (scheme != null) {
                this.renameScheme(scheme, schemeData.name);
            }
            return (E)scheme;
        }
        return (E)this.myProcessor.readScheme(subDocument);
    }

    @Nullable
    private static Document loadGlobalScheme(String schemePath) throws IOException, JDOMException {
        StreamProvider[] providers;
        for (StreamProvider provider : providers = ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager().getStreamProviders(RoamingType.GLOBAL)) {
            Document document;
            if (!provider.isEnabled() || (document = StorageUtil.loadDocument(provider.loadContent(schemePath, RoamingType.GLOBAL))) == null) continue;
            return document;
        }
        return null;
    }

    private void saveFileName(String fileName, E schemeKey) {
        if (StringUtil.endsWithIgnoreCase((String)fileName, (String)EXT)) {
            fileName = fileName.substring(0, fileName.length() - EXT.length());
        }
        schemeKey.getExternalInfo().setCurrentFileName(fileName);
    }

    private static long computeHashValue(Document document) throws IOException {
        return StringHash.calc((byte[])JDOMUtil.printDocument((Document)document, (String)"\n"));
    }

    @Nullable
    private Document writeSchemeToDocument(E scheme) throws WriteExternalException {
        if (!this.isShared((Scheme)scheme)) {
            return this.myProcessor.writeScheme(scheme);
        }
        String originalPath = scheme.getExternalInfo().getOriginalPath();
        if (originalPath != null) {
            Element root = new Element(SHARED_SCHEME);
            root.setAttribute(NAME, scheme.getName());
            root.setAttribute(ORIGINAL_SCHEME_PATH, originalPath);
            Element localCopy = new Element(SCHEME_LOCAL_COPY);
            localCopy.addContent((Element)this.myProcessor.writeScheme(scheme).getRootElement().clone());
            root.addContent(localCopy);
            return new Document(root);
        }
        return null;
    }

    public void updateConfigFilesFromStreamProviders() {
    }

    @NotNull
    public Collection<SharedScheme<E>> loadSharedSchemes(Collection<T> currentSchemeList) {
        HashSet names = new HashSet(this.getAllSchemeNames(currentSchemeList));
        StreamProvider[] providers = ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager().getStreamProviders(RoamingType.GLOBAL);
        HashMap<String, SharedScheme> result = new HashMap<String, SharedScheme>();
        if (providers != null) {
            for (StreamProvider provider : providers) {
                String[] paths;
                if (!provider.isEnabled()) continue;
                for (String subpath : paths = provider.listSubFiles(this.myFileSpec)) {
                    try {
                        Document subDocument = StorageUtil.loadDocument(provider.loadContent(this.getFileFullPath(subpath), RoamingType.GLOBAL));
                        if (subDocument == null) continue;
                        SharedSchemeData original = this.unwrap(subDocument);
                        ExternalizableScheme scheme = this.myProcessor.readScheme(original.original);
                        if (this.alreadyShared(subpath, currentSchemeList)) continue;
                        String schemeName = original.name;
                        String uniqueName = UniqueNameGenerator.generateUniqueName((String)("[shared] " + schemeName), (String)"", (String)"", (Collection)names);
                        this.renameScheme(scheme, uniqueName);
                        schemeName = uniqueName;
                        scheme.getExternalInfo().setOriginalPath(this.getFileFullPath(subpath));
                        scheme.getExternalInfo().setIsImported(true);
                        result.put(schemeName, new SharedScheme(original.user == null ? "unknown" : original.user, original.description, scheme));
                    }
                    catch (Exception e) {
                        LOG.debug("Cannot load data from IDEAServer: " + e.getLocalizedMessage());
                    }
                }
            }
        }
        for (SharedScheme t : result.values()) {
            this.myProcessor.initScheme(t.getScheme());
        }
        Collection<SharedScheme<E>> collection = result.values();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/options/SchemesManagerImpl.loadSharedSchemes must not return null");
        }
        return collection;
    }

    private SharedSchemeData unwrap(Document subDocument) {
        SharedSchemeData result = new SharedSchemeData();
        Element rootElement = subDocument.getRootElement();
        if (rootElement.getName().equals(SHARED_SCHEME_ORIGINAL)) {
            result.name = rootElement.getAttributeValue(NAME);
            result.description = rootElement.getAttributeValue(DESCRIPTION);
            result.user = rootElement.getAttributeValue(USER);
            result.original = new Document((Element)((Element)rootElement.getChildren().iterator().next()).clone());
        } else {
            result.name = rootElement.getAttributeValue(NAME);
            result.original = subDocument;
        }
        return result;
    }

    private boolean alreadyShared(String subpath, Collection<T> currentSchemeList) {
        for (Scheme t : currentSchemeList) {
            ExternalInfo info;
            if (!(t instanceof ExternalizableScheme) || !(info = ((ExternalizableScheme)t).getExternalInfo()).isIsImported() || !this.getFileFullPath(subpath).equals(info.getOriginalPath())) continue;
            return true;
        }
        return false;
    }

    private String getFileFullPath(String subpath) {
        return this.myFileSpec + "/" + subpath;
    }

    public void exportScheme(E scheme, String name, String description) throws WriteExternalException, IOException {
        Document document;
        StreamProvider[] providers = ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager().getStreamProviders(RoamingType.GLOBAL);
        if (providers != null && (document = this.myProcessor.writeScheme(scheme)) != null) {
            Document wrapped = this.wrap(document, name, description);
            for (StreamProvider provider : providers) {
                if (provider instanceof CurrentUserHolder) {
                    wrapped = (Document)wrapped.clone();
                    String userName = ((CurrentUserHolder)provider).getCurrentUserName();
                    if (userName != null) {
                        wrapped.getRootElement().setAttribute(USER, userName);
                    }
                }
                StorageUtil.sendContent(provider, this.getFileFullPath(UniqueFileNamesProvider.convertName((String)scheme.getName())) + EXT, wrapped, RoamingType.GLOBAL, false);
            }
        }
    }

    private Document wrap(Document original, String name, String description) {
        Element sharedElement = new Element(SHARED_SCHEME_ORIGINAL);
        sharedElement.setAttribute(NAME, name);
        sharedElement.setAttribute(DESCRIPTION, description);
        sharedElement.addContent((Element)original.getRootElement().clone());
        return new Document(sharedElement);
    }

    public boolean isImportAvailable() {
        StreamProvider[] providers = ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager().getStreamProviders(RoamingType.GLOBAL);
        if (providers == null) {
            return false;
        }
        for (StreamProvider provider : providers) {
            if (!provider.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isExportAvailable() {
        return false;
    }

    public boolean isShared(Scheme scheme) {
        return scheme instanceof ExternalizableScheme && ((ExternalizableScheme)scheme).getExternalInfo().isIsImported();
    }

    @Override
    public void save() throws WriteExternalException {
        if (this.myRefreshAlarm != null) {
            this.myRefreshAlarm.cancelAllRequests();
            this.myRefreshAlarm = null;
        }
        if (this.myVFSBaseDir == null) {
            this.ensureVFSBaseDir();
        }
        if (this.myVFSBaseDir != null) {
            final WriteExternalException[] ex = new WriteExternalException[1];
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        SchemesManagerImpl.this.doSave();
                    }
                    catch (WriteExternalException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        }
    }

    private void ensureVFSBaseDir() {
        this.myBaseDir.mkdirs();
        this.myVFSBaseDir = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(Result<VirtualFile> result) {
                VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(SchemesManagerImpl.this.myBaseDir);
                result.setResult((Object)dir);
                if (dir != null) {
                    dir.getChildren();
                    ((NewVirtualFile)dir).markDirtyRecursively();
                    dir.refresh(false, true);
                }
            }
        }.execute().getResultObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave() throws WriteExternalException {
        this.myInsideSave = true;
        try {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ((NewVirtualFile)SchemesManagerImpl.this.myVFSBaseDir).markDirtyRecursively();
                    SchemesManagerImpl.this.myVFSBaseDir.refresh(false, true);
                }
            });
            List schemes = this.getAllSchemes();
            this.myBaseDir.mkdirs();
            UniqueFileNamesProvider fileNameProvider = new UniqueFileNamesProvider();
            this.reserveUsingFileNames(schemes, fileNameProvider);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    SchemesManagerImpl.this.deleteFilesFromDeletedSchemes();
                }
            });
            this.saveSchemes(schemes, fileNameProvider);
            if (this.myDeletedNames.size() > 0) {
                for (StreamProvider provider : this.getEnabledProviders()) {
                    try {
                        StorageUtil.sendContent(provider, this.getFileFullPath(DELETED_XML), this.createDeletedDocument(), this.myRoamingType, true);
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            } else {
                this.deleteServerFiles(DELETED_XML);
            }
        }
        finally {
            this.myInsideSave = false;
        }
    }

    public File getRootDirectory() {
        return this.myBaseDir;
    }

    private void deleteFilesFromDeletedSchemes() {
        for (String deletedName : this.myFilesToDelete) {
            this.deleteLocalAndServerFiles(deletedName + EXT);
        }
        this.myFilesToDelete.clear();
    }

    private void deleteLocalAndServerFiles(String fileName) {
        VirtualFile file = this.myVFSBaseDir.findChild(fileName);
        if (file != null) {
            try {
                file.delete((Object)this);
            }
            catch (IOException e) {
                LOG.info("Canot delete file " + file.getPath() + ": " + e.getLocalizedMessage());
            }
        }
        this.deleteServerFiles(fileName);
    }

    private void deleteServerFiles(String fileName) {
        for (StreamProvider provider : this.getEnabledProviders()) {
            provider.deleteFile(this.getFileFullPath(fileName), this.myRoamingType);
        }
    }

    private void saveSchemes(Collection<T> schemes, UniqueFileNamesProvider fileNameProvider) throws WriteExternalException {
        for (Scheme scheme : schemes) {
            if (!this.isExternalizable(scheme)) continue;
            final ExternalizableScheme eScheme = (ExternalizableScheme)scheme;
            eScheme.getExternalInfo().setPreviouslySavedName(eScheme.getName());
            if (!this.myProcessor.shouldBeSaved(eScheme)) continue;
            String fileName = this.getFileNameForScheme(fileNameProvider, eScheme);
            try {
                Document document = this.writeSchemeToDocument(eScheme);
                if (document == null) continue;
                long newHash = SchemesManagerImpl.computeHashValue(document);
                Long oldHash = eScheme.getExternalInfo().getHash();
                this.saveIfNeeded(eScheme, fileName, document, newHash, oldHash);
            }
            catch (IOException e) {
                Application app = ApplicationManager.getApplication();
                if (app.isUnitTestMode() || app.isCommandLine()) {
                    LOG.error("Cannot write scheme " + fileName + " in '" + this.myFileSpec + "': " + e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
                app.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)("Cannot save scheme '" + eScheme.getName() + ": " + e.getLocalizedMessage()), (String)"Save Settings");
                    }
                });
            }
        }
    }

    private String getFileNameForScheme(UniqueFileNamesProvider fileNameProvider, E scheme) {
        String fileName;
        if (scheme.getExternalInfo().getCurrentFileName() != null) {
            fileName = scheme.getExternalInfo().getCurrentFileName();
            fileNameProvider.reserveFileName(fileName);
        } else {
            fileName = fileNameProvider.suggestName(scheme.getName());
        }
        return fileName + EXT;
    }

    private void saveIfNeeded(E schemeKey, String fileName, Document document, long newHash, Long oldHash) throws IOException {
        if (oldHash == null || newHash != oldHash || this.myVFSBaseDir.findChild(fileName) == null) {
            if (oldHash != null && newHash != oldHash) {
                byte[] text = StorageUtil.printDocument(document);
                this.ensureFileText(fileName, text);
            } else {
                byte[] text = StorageUtil.printDocument(document);
                this.ensureFileText(fileName, text);
            }
            schemeKey.getExternalInfo().setHash(newHash);
            this.saveFileName(fileName, schemeKey);
            this.saveOnServer(fileName, document);
        }
    }

    private boolean needsSave(String fileName, byte[] text) throws IOException {
        VirtualFile file = this.myVFSBaseDir.findChild(fileName);
        if (file != null) {
            return !Arrays.equals(file.contentsToByteArray(), text);
        }
        return true;
    }

    private void saveOnServer(String fileName, Document document) {
        for (StreamProvider provider : this.getEnabledProviders()) {
            try {
                StorageUtil.sendContent(provider, this.getFileFullPath(fileName), document, this.myRoamingType, true);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private Collection<StreamProvider> getEnabledProviders() {
        ArrayList<StreamProvider> result = new ArrayList<StreamProvider>();
        for (StreamProvider provider : this.myProviders) {
            if (!provider.isEnabled()) continue;
            result.add(provider);
        }
        return result;
    }

    private void reserveUsingFileNames(Collection<T> schemes, UniqueFileNamesProvider fileNameProvider) {
        fileNameProvider.reserveFileName(DELETED_XML);
        for (Scheme scheme : schemes) {
            ExternalInfo info;
            String fileName;
            if (!(scheme instanceof ExternalizableScheme) || (fileName = (info = ((ExternalizableScheme)scheme).getExternalInfo()).getCurrentFileName()) == null) continue;
            if (Comparing.equal((String)info.getPreviouslySavedName(), (String)scheme.getName())) {
                fileNameProvider.reserveFileName(fileName);
                continue;
            }
            this.myFilesToDelete.add(fileName);
            info.setCurrentFileName(null);
        }
    }

    private Document createDeletedDocument() {
        Element root = new Element("deleted-schemes");
        Document result = new Document(root);
        for (String deletedName : this.myDeletedNames) {
            Element child = new Element("scheme");
            root.addContent(child);
            child.setAttribute(NAME, deletedName);
        }
        return result;
    }

    @Override
    protected void onSchemeDeleted(Scheme toDelete) {
        if (toDelete instanceof ExternalizableScheme) {
            ExternalInfo info = ((ExternalizableScheme)toDelete).getExternalInfo();
            String previouslyUsedName = info.getPreviouslySavedName();
            if (previouslyUsedName != null) {
                this.myDeletedNames.add(previouslyUsedName);
            }
            if (info.getCurrentFileName() != null) {
                this.myFilesToDelete.add(info.getCurrentFileName());
            }
        }
    }

    @Override
    protected void onSchemeAdded(T scheme) {
        this.myDeletedNames.remove(scheme.getName());
        if (scheme instanceof ExternalizableScheme) {
            ((ExternalizableScheme)scheme).getExternalInfo().setPreviouslySavedName(scheme.getName());
        }
    }

    class SharedSchemeData {
        Document original;
        String name;
        String user;
        String description;
        E scheme;

        SharedSchemeData() {
        }
    }
}

