/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class FileTypeRenderer
extends DefaultListCellRenderer {
    private static final Icon EMPTY_ICON = new EmptyIcon(18, 18);
    private final FileTypeListProvider myFileTypeListProvider;

    public FileTypeRenderer(FileTypeListProvider fileTypeListProvider) {
        this.myFileTypeListProvider = fileTypeListProvider;
    }

    public FileTypeRenderer() {
        this(new DefaultFileTypeListProvider());
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        FileType type = (FileType)value;
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        Icon icon = type.getIcon();
        if (icon != null) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        this.setIcon((Icon)layeredIcon);
        if (this.isDuplicated(type.getDescription())) {
            this.setText(type.getDescription() + " (" + type.getName() + ")");
        } else {
            this.setText(type.getDescription());
        }
        return this;
    }

    private boolean isDuplicated(String description) {
        boolean found = false;
        for (FileType type : this.myFileTypeListProvider.getCurrentFileTypeList()) {
            if (!description.equals(type.getDescription())) continue;
            if (!found) {
                found = true;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 20);
    }

    private static class DefaultFileTypeListProvider
    implements FileTypeListProvider {
        private final List<FileType> myFileTypes = Arrays.asList(FileTypeManager.getInstance().getRegisteredFileTypes());

        @Override
        public Iterable<FileType> getCurrentFileTypeList() {
            return this.myFileTypes;
        }
    }

    public static interface FileTypeListProvider {
        public Iterable<FileType> getCurrentFileTypeList();
    }
}

