/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;

public final class VirtualFileDeleteProvider
implements DeleteProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider");

    public boolean canDeleteElement(DataContext dataContext) {
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        return files != null && files.length > 0;
    }

    public void deleteElement(DataContext dataContext) {
        final VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files == null || files.length == 0) {
            return;
        }
        String message = VirtualFileDeleteProvider.createConfirmationMessage(files);
        int returnValue = Messages.showYesNoDialog((String)message, (String)UIBundle.message((String)"delete.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (returnValue != 0) {
            return;
        }
        Arrays.sort(files, FileComparator.getInstance());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (final VirtualFile file : files) {
                    try {
                        file.delete((Object)this);
                    }
                    catch (IOException e) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showMessageDialog((String)UIBundle.message((String)"file.chooser.could.not.erase.file.or.folder.error.messabe", (Object[])new Object[]{file.getName()}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                            }
                        });
                    }
                }
            }
        });
    }

    private static String createConfirmationMessage(VirtualFile[] filesToDelete) {
        if (filesToDelete.length == 1) {
            if (filesToDelete[0].isDirectory()) {
                return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folder.confirmation.message", (Object[])new Object[0]);
            }
            return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.file.confirmation.message", (Object[])new Object[0]);
        }
        boolean hasFiles = false;
        boolean hasFolders = false;
        for (VirtualFile file : filesToDelete) {
            boolean isDirectory = file.isDirectory();
            hasFiles |= !isDirectory;
            hasFolders |= isDirectory;
        }
        LOG.assertTrue(hasFiles || hasFolders);
        if (hasFiles && hasFolders) {
            return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.directories.confirmation.message", (Object[])new Object[0]);
        }
        if (hasFolders) {
            return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folders.confirmation.message", (Object[])new Object[0]);
        }
        return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.files.confirmation.message", (Object[])new Object[0]);
    }

    private static final class FileComparator
    implements Comparator<VirtualFile> {
        private static final FileComparator ourInstance = new FileComparator();

        private FileComparator() {
        }

        public static FileComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o2.getPath().compareTo(o1.getPath());
        }
    }
}

