/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;

public class FontInfo {
    private final String myFamilyName;
    private final Font myFont;
    private final int mySize;
    private final int myStyle;
    private final TIntHashSet mySafeCharacters = new TIntHashSet();
    private FontMetrics myFontMetrics = null;
    private final int[] charWidth = new int[128];

    public FontInfo(String familyName, int size, int style) {
        this.myFamilyName = familyName;
        this.mySize = size;
        this.myStyle = style;
        this.myFont = new Font(familyName, style, size);
    }

    public boolean canDisplay(char c) {
        try {
            if (c < '\u0080') {
                return true;
            }
            if (this.mySafeCharacters.contains((int)c)) {
                return true;
            }
            if (this.myFont.canDisplay(c)) {
                this.mySafeCharacters.add((int)c);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Font getFont() {
        return this.myFont;
    }

    public int charWidth(char c, JComponent anyComponent) {
        FontMetrics metrics = this.fontMetrics(anyComponent);
        if (c < '\u0080') {
            return this.charWidth[c];
        }
        return metrics.charWidth(c);
    }

    private FontMetrics fontMetrics(JComponent anyComponent) {
        if (this.myFontMetrics == null) {
            this.myFontMetrics = anyComponent.getFontMetrics(this.myFont);
            for (int i = 0; i < 128; ++i) {
                this.charWidth[i] = this.myFontMetrics.charWidth(i);
            }
        }
        return this.myFontMetrics;
    }

    public int getSize() {
        return this.mySize;
    }

    public int getStyle() {
        return this.myStyle;
    }
}

