/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighter;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighterImpl;
import com.intellij.openapi.diff.impl.fragments.FragmentList;
import com.intellij.openapi.diff.impl.fragments.FragmentListImpl;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.DiffMarkup;
import com.intellij.openapi.diff.impl.processing.TextCompareProcessor;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleDiffPanelState<DiffMarkupType extends DiffMarkup>
implements Disposable {
    private ComparisonPolicy myComparisonPolicy = ComparisonPolicy.DEFAULT;
    protected final DiffMarkupType myAppender1;
    protected final DiffMarkupType myAppender2;
    private FragmentList myFragmentList = FragmentList.EMPTY;
    private final Project myProject;

    public SimpleDiffPanelState(DiffMarkupType diffMarkup1, DiffMarkupType diffMarkup2, Project project) {
        this.myAppender1 = diffMarkup1;
        this.myAppender2 = diffMarkup2;
        this.myProject = project;
    }

    public void setComparisonPolicy(ComparisonPolicy comparisonPolicy) {
        this.myComparisonPolicy = comparisonPolicy;
    }

    public ComparisonPolicy getComparisonPolicy() {
        return this.myComparisonPolicy;
    }

    public void dispose() {
        ((DiffMarkup)this.myAppender1).dispose();
        ((DiffMarkup)this.myAppender2).dispose();
    }

    private LineBlocks addMarkup(final ArrayList<LineFragment> lines) {
        this.resetMarkup();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    LineFragment line = (LineFragment)iterator.next();
                    FragmentHighlighterImpl fragmentHighlighter = new FragmentHighlighterImpl((DiffMarkup)SimpleDiffPanelState.this.myAppender1, (DiffMarkup)SimpleDiffPanelState.this.myAppender2, !iterator.hasNext());
                    line.highlight((FragmentHighlighter)fragmentHighlighter);
                }
            }
        });
        ArrayList<LineFragment> allLineFragments = new ArrayList<LineFragment>();
        for (LineFragment lineFragment : lines) {
            allLineFragments.add(lineFragment);
            lineFragment.addAllDescendantsTo(allLineFragments);
        }
        this.myFragmentList = FragmentListImpl.fromList(allLineFragments);
        return LineBlocks.fromLineFragments(allLineFragments);
    }

    private void resetMarkup() {
        ApplicationManager.getApplication().runWriteAction((Runnable)new ResetMarkupRunnable(this));
    }

    public LineBlocks updateEditors() {
        if (this.myAppender1.getEditor() == null || this.myAppender2.getEditor() == null) {
            this.resetMarkup();
            return LineBlocks.EMPTY;
        }
        return this.addMarkup(new TextCompareProcessor(this.myComparisonPolicy).process(((DiffMarkup)this.myAppender1).getText(), ((DiffMarkup)this.myAppender2).getText()));
    }

    public Project getProject() {
        return this.myProject;
    }

    public FragmentList getFragmentList() {
        return this.myFragmentList;
    }

    private static class ResetMarkupRunnable
    implements Runnable {
        private final SimpleDiffPanelState myState;

        public ResetMarkupRunnable(SimpleDiffPanelState state) {
            this.myState = state;
        }

        @Override
        public void run() {
            ((DiffMarkup)this.myState.myAppender1).resetHighlighters();
            ((DiffMarkup)this.myState.myAppender2).resetHighlighters();
        }
    }
}

