/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.List2D;
import com.intellij.openapi.util.text.StringUtil;

public abstract class LineBlockDivider {
    public static final LineBlockDivider SINGLE_SIDE = new LineBlockDivider(){

        @Override
        public DiffFragment[][] divide(DiffFragment[] lineBlock) {
            List2D result = new List2D();
            FragmentSide currentSide = null;
            boolean isNewLineLast = true;
            for (int i = 0; i < lineBlock.length; ++i) {
                DiffFragment fragment = lineBlock[i];
                if (!fragment.isOneSide()) {
                    if (currentSide != null && isNewLineLast) {
                        result.newRow();
                    }
                    isNewLineLast = StringUtil.endsWithChar((CharSequence)fragment.getText1(), (char)'\n') && StringUtil.endsWithChar((CharSequence)fragment.getText2(), (char)'\n');
                    currentSide = null;
                } else {
                    FragmentSide side = FragmentSide.chooseSide((DiffFragment)fragment);
                    if (currentSide != side) {
                        if (isNewLineLast) {
                            result.newRow();
                            currentSide = side;
                        } else {
                            currentSide = null;
                        }
                    }
                    isNewLineLast = StringUtil.endsWithChar((CharSequence)side.getText(fragment), (char)'\n');
                }
                result.add(fragment);
            }
            return result.toArray();
        }
    };

    public abstract DiffFragment[][] divide(DiffFragment[] var1);
}

