/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NonNls;

class EditorChangeAction
implements UndoableAction {
    private final DocumentReference myReference;
    private final int myOffset;
    private final CharSequence myOldString;
    private final CharSequence myNewString;
    private final long myTimeStamp;
    private final boolean myBulkUpdate;

    public EditorChangeAction(DocumentEx document, int offset, CharSequence oldString, CharSequence newString, long oldTimeStamp) {
        this.myReference = DocumentReferenceManager.getInstance().create((Document)document);
        this.myOffset = offset;
        this.myOldString = oldString == null ? "" : oldString;
        this.myNewString = newString == null ? "" : newString;
        this.myTimeStamp = oldTimeStamp;
        this.myBulkUpdate = document.isInBulkUpdate();
    }

    public void undo() {
        this.exchangeStrings(this.myNewString, this.myOldString);
        this.getDocument().setModificationStamp(this.myTimeStamp);
        this.refreshFileStatus();
    }

    public void redo() {
        this.exchangeStrings(this.myOldString, this.myNewString);
        this.refreshFileStatus();
    }

    private void exchangeStrings(CharSequence newString, CharSequence oldString) {
        DocumentEx d = this.getDocument();
        if (this.myBulkUpdate) {
            d.setInBulkUpdate(true);
        }
        if (newString.length() > 0 && oldString.length() == 0) {
            d.deleteString(this.myOffset, this.myOffset + newString.length());
        } else if (oldString.length() > 0 && newString.length() == 0) {
            d.insertString(this.myOffset, oldString);
        } else if (oldString.length() > 0 && newString.length() > 0) {
            d.replaceString(this.myOffset, this.myOffset + newString.length(), oldString);
        }
        if (this.myBulkUpdate) {
            d.setInBulkUpdate(false);
        }
    }

    private void refreshFileStatus() {
        VirtualFile f = this.myReference.getFile();
        if (f == null || f instanceof LightVirtualFile) {
            return;
        }
        for (Project each : ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManagerImpl statusManager = (FileStatusManagerImpl)FileStatusManager.getInstance((Project)each);
            statusManager.refreshFileStatusFromDocument(f, this.getDocument());
        }
    }

    public DocumentReference[] getAffectedDocuments() {
        return new DocumentReference[]{this.myReference};
    }

    public boolean isGlobal() {
        return false;
    }

    private DocumentEx getDocument() {
        return (DocumentEx)this.myReference.getDocument();
    }

    @NonNls
    public String toString() {
        return "editor change: '" + this.myOldString + "' to '" + this.myNewString + "'";
    }
}

