/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lifecycle;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PeriodicalTasksCloser
implements ProjectManagerListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lifecycle.PeriodicalTasksCloser");
    private static final Object ourLock = new Object();
    private final List<Pair<String, Runnable>> myInterrupters;
    private static final Map<Project, Boolean> myStates = new HashMap<Project, Boolean>();
    private final Project myProject;

    private PeriodicalTasksCloser(Project project, ProjectManager projectManager) {
        this.myProject = project;
        this.myInterrupters = new ArrayList<Pair<String, Runnable>>();
        projectManager.addProjectManagerListener(project, (ProjectManagerListener)this);
    }

    public static PeriodicalTasksCloser getInstance(Project project) {
        return (PeriodicalTasksCloser)ServiceManager.getService((Project)project, PeriodicalTasksCloser.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(String name, Runnable runnable) {
        Object object = ourLock;
        synchronized (object) {
            if (Boolean.FALSE.equals(myStates.get(this.myProject))) {
                return false;
            }
            this.myInterrupters.add((Pair<String, Runnable>)new Pair((Object)name, (Object)runnable));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectOpened(Project project) {
        Object object = ourLock;
        synchronized (object) {
            myStates.put(project, Boolean.TRUE);
        }
    }

    public boolean canCloseProject(Project project) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed(Project project) {
        Object object = ourLock;
        synchronized (object) {
            myStates.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosing(Project project) {
        Object object = ourLock;
        synchronized (object) {
            myStates.put(project, Boolean.FALSE);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list;
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                Object object = ourLock;
                synchronized (object) {
                    list = PeriodicalTasksCloser.this.myInterrupters;
                }
                for (Pair pair : list) {
                    if (indicator != null) {
                        indicator.setText((String)pair.getFirst());
                        indicator.checkCanceled();
                    }
                    ((Runnable)pair.getSecond()).run();
                }
            }
        }, "Please wait for safe shutdown of periodical tasks...", true, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T safeGetComponent(@NotNull Project project, Class<T> componentClass) throws ProcessCanceledException {
        Object component;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lifecycle/PeriodicalTasksCloser.safeGetComponent must not be null");
        }
        try {
            component = project.getComponent(componentClass);
        }
        catch (Throwable t) {
            if (!(t instanceof NullPointerException) && !(t instanceof AssertionError)) {
                LOG.info(t);
            }
            throw new ProcessCanceledException();
        }
        Object object = ourLock;
        synchronized (object) {
            Boolean state = myStates.get(project);
            if (state != null && !Boolean.TRUE.equals(state)) {
                throw new ProcessCanceledException();
            }
            return (T)component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWaitInterruptedWhenClosing(Project project, final Runnable runnable, ModalityState modalityState) {
        final Ref start = new Ref((Object)Boolean.TRUE);
        Application application = ApplicationManager.getApplication();
        LOG.assertTrue(!application.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        Runnable runnable1 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "PeriodicalTaskCloser's invoke and wait [" + runnable.toString() + "]";
            }
        };
        LaterInvocator.invokeLater(runnable1, modalityState, new Condition<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean value(Object o) {
                Ref ref = start;
                synchronized (ref) {
                    return (Boolean)start.get() == false;
                }
            }
        });
        while (!semaphore.waitFor(1000L)) {
            Ref fire = new Ref();
            if (project == null) continue;
            Object object = ourLock;
            synchronized (object) {
                Boolean state = myStates.get(project);
                if (!Boolean.TRUE.equals(state)) {
                    fire.set((Object)Boolean.TRUE);
                }
                if (Boolean.TRUE.equals(fire.get())) {
                    Ref ref = start;
                    synchronized (ref) {
                        start.set((Object)Boolean.FALSE);
                        return;
                    }
                }
            }
        }
        return;
    }
}

