/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.LangBundle;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.xml.TypeNameManager;
import org.jetbrains.annotations.NotNull;

public class JavaFindUsagesProvider
implements FindUsagesProvider {
    public static final String DEFAULT_PACKAGE_NAME = UsageViewBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]);

    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/JavaFindUsagesProvider.canFindUsagesFor must not be null");
        }
        if (element instanceof PsiDirectory) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            return psiPackage != null && psiPackage.getQualifiedName().length() != 0;
        }
        return element instanceof PsiClass || element instanceof PsiVariable || element instanceof PsiMethod || element instanceof PsiPackage || element instanceof PsiLabeledStatement || ThrowSearchUtil.isSearchable(element) || element instanceof PsiMetaOwner && ((PsiMetaOwner)element).getMetaData() != null;
    }

    public String getHelpId(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/JavaFindUsagesProvider.getHelpId must not be null");
        }
        if (element instanceof PsiPackage) {
            return "reference.dialogs.findUsages.package";
        }
        if (element instanceof PsiClass) {
            return "reference.dialogs.findUsages.class";
        }
        if (element instanceof PsiMethod) {
            return "reference.dialogs.findUsages.method";
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            return "reference.dialogs.findUsages.throwUsages";
        }
        return "reference.dialogs.findUsages.other";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getType(@NotNull PsiElement element) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/JavaFindUsagesProvider.getType must not be null");
        }
        if (element instanceof PsiDirectory) {
            String string2 = LangBundle.message("terms.directory", new Object[0]);
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
        }
        if (element instanceof PsiFile) {
            String string3 = LangBundle.message("terms.file", new Object[0]);
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string4 = LangBundle.message("java.terms.exception", new Object[0]);
            string = string4;
            if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof PsiPackage) {
            String string5 = LangBundle.message("java.terms.package", new Object[0]);
            string = string5;
            if (string5 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string6 = LangBundle.message("java.terms.label", new Object[0]);
            string = string6;
            if (string6 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof PsiClass) {
            if (((PsiClass)element).isAnnotationType()) {
                String string7 = LangBundle.message("java.terms.annotation.interface", new Object[0]);
                string = string7;
                if (string7 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
                return string;
            }
            if (((PsiClass)element).isEnum()) {
                String string8 = LangBundle.message("java.terms.enum", new Object[0]);
                string = string8;
                if (string8 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
                return string;
            }
            if (((PsiClass)element).isInterface()) {
                String string9 = LangBundle.message("java.terms.interface", new Object[0]);
                string = string9;
                if (string9 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
                return string;
            }
            if (element instanceof PsiTypeParameter) {
                String string10 = LangBundle.message("java.terms.type.parameter", new Object[0]);
                string = string10;
                if (string10 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
                return string;
            }
            String string11 = LangBundle.message("java.terms.class", new Object[0]);
            string = string11;
            if (string11 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof PsiField) {
            String string12 = LangBundle.message("java.terms.field", new Object[0]);
            string = string12;
            if (string12 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof PsiParameter) {
            String string13 = LangBundle.message("java.terms.parameter", new Object[0]);
            string = string13;
            if (string13 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof PsiLocalVariable) {
            String string14 = LangBundle.message("java.terms.variable", new Object[0]);
            string = string14;
            if (string14 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            boolean isConstructor = psiMethod.isConstructor();
            if (isConstructor) {
                String string15 = LangBundle.message("java.terms.constructor", new Object[0]);
                string = string15;
                if (string15 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
                return string;
            }
            String string16 = LangBundle.message("java.terms.method", new Object[0]);
            string = string16;
            if (string16 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof PsiExpression) {
            String string17 = LangBundle.message("java.terms.expression", new Object[0]);
            string = string17;
            if (string17 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
            return string;
        }
        String name = TypeNameManager.getTypeName(element.getClass());
        if (name == null) return "";
        String string18 = name;
        string = string18;
        if (string18 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getType must not return null");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not be null");
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string2 = ThrowSearchUtil.getSearchableTypeName(element);
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
        }
        if (element instanceof PsiDirectory) {
            String string3 = JavaFindUsagesProvider.getPackageName((PsiDirectory)element, false);
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiPackage) {
            String string4 = JavaFindUsagesProvider.getPackageName((PsiPackage)element);
            string = string4;
            if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiFile) {
            String string5 = ((PsiFile)element).getVirtualFile().getPresentableUrl();
            string = string5;
            if (string5 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string6 = ((PsiLabeledStatement)element).getLabelIdentifier().getText();
            string = string6;
            if (string6 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiClass) {
            if (element instanceof PsiAnonymousClass) {
                String string7 = LangBundle.message("java.terms.anonymous.class", new Object[0]);
                string = string7;
                if (string7 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
                return string;
            }
            PsiClass aClass = (PsiClass)element;
            String qName = aClass.getQualifiedName();
            String string8 = qName == null ? aClass.getName() : qName;
            string = string8;
            if (string8 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            String formatted = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass != null) {
                String string9 = JavaFindUsagesProvider.getContainingClassDescription(psiClass, formatted);
                string = string9;
                if (string9 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
                return string;
            }
            String string10 = formatted;
            string = string10;
            if (string10 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiField) {
            PsiField psiField = (PsiField)element;
            String formatted = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiClass psiClass = psiField.getContainingClass();
            if (psiClass != null) {
                String string11 = JavaFindUsagesProvider.getContainingClassDescription(psiClass, formatted);
                string = string11;
                if (string11 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
                return string;
            }
            String string12 = formatted;
            string = string12;
            if (string12 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiVariable) {
            String string13 = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            string = string13;
            if (string13 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (!(element instanceof PsiLiteralExpression)) return "";
        String string14 = element.getText();
        string = string14;
        if (string14 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getDescriptiveName must not return null");
        return string;
    }

    private static String getContainingClassDescription(PsiClass aClass, String formatted) {
        if (aClass instanceof PsiAnonymousClass) {
            return LangBundle.message("java.terms.of.anonymous.class", formatted);
        }
        String className = aClass.getName();
        if (aClass.isInterface()) {
            return LangBundle.message("java.terms.of.interface", formatted, className);
        }
        if (aClass.isEnum()) {
            return LangBundle.message("java.terms.of.enum", formatted, className);
        }
        if (aClass.isAnnotationType()) {
            return LangBundle.message("java.terms.of.annotation.type", formatted, className);
        }
        return LangBundle.message("java.terms.of.class", formatted, className);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not be null");
        }
        if (element instanceof PsiDirectory) {
            String string2 = JavaFindUsagesProvider.getPackageName((PsiDirectory)element, false);
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
        }
        if (element instanceof PsiPackage) {
            String string3 = JavaFindUsagesProvider.getPackageName((PsiPackage)element);
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (element instanceof PsiFile) {
            String string4 = useFullName ? ((PsiFile)element).getVirtualFile().getPresentableUrl() : ((PsiFile)element).getName();
            string = string4;
            if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string5 = ((PsiLabeledStatement)element).getLabelIdentifier().getText();
            string = string5;
            if (string5 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string6 = ThrowSearchUtil.getSearchableTypeName(element);
            string = string6;
            if (string6 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getQualifiedName();
            if (name == null || !useFullName) {
                name = ((PsiClass)element).getName();
            }
            if (name != null) {
                String string7 = name;
                string = string7;
                if (string7 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
                return string;
            }
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (useFullName) {
                String qName;
                String s = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)3);
                PsiClass psiClass = psiMethod.getContainingClass();
                if (psiClass != null && (qName = psiClass.getQualifiedName()) != null) {
                    s = psiClass.isInterface() ? LangBundle.message("java.terms.of.interface", s, qName) : LangBundle.message("java.terms.of.class", s, qName);
                }
                String string8 = s;
                string = string8;
                if (string8 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
                return string;
            }
            String string9 = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            string = string9;
            if (string9 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)((PsiParameter)element).getDeclarationScope();
            String s = LangBundle.message("java.terms.variable.of.method", PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY), PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2));
            PsiClass psiClass = method.getContainingClass();
            if (psiClass != null && psiClass.getQualifiedName() != null) {
                s = psiClass.isInterface() ? LangBundle.message("java.terms.of.interface", s, psiClass.getQualifiedName()) : LangBundle.message("java.terms.of.class", s, psiClass.getQualifiedName());
            }
            String string10 = s;
            string = string10;
            if (string10 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (element instanceof PsiField) {
            String qName;
            PsiField psiField = (PsiField)element;
            String s = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiClass psiClass = psiField.getContainingClass();
            if (psiClass != null && (qName = psiClass.getQualifiedName()) != null) {
                s = psiClass.isInterface() ? LangBundle.message("java.terms.of.interface", s, qName) : LangBundle.message("java.terms.of.class", s, qName);
            }
            String string11 = s;
            string = string11;
            if (string11 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (!(element instanceof PsiVariable)) return "";
        String string12 = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        string = string12;
        if (string12 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFindUsagesProvider.getNodeText must not return null");
        return string;
    }

    public static String getPackageName(PsiDirectory directory, boolean includeRootDir) {
        String rootDir;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            return directory.getVirtualFile().getPresentableUrl();
        }
        String packageName = JavaFindUsagesProvider.getPackageName(aPackage);
        if (includeRootDir && (rootDir = JavaFindUsagesProvider.getRootDirectoryForPackage(directory)) != null) {
            return UsageViewBundle.message((String)"usage.target.package.in.directory", (Object[])new Object[]{packageName, rootDir});
        }
        return packageName;
    }

    public static String getRootDirectoryForPackage(PsiDirectory directory) {
        PsiManager manager = directory.getManager();
        VirtualFile virtualFile = directory.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)manager.getProject()).getFileIndex();
        VirtualFile root = fileIndex.getSourceRootForFile(virtualFile);
        if (root == null) {
            root = fileIndex.getClassRootForFile(virtualFile);
        }
        if (root != null) {
            return root.getPresentableUrl();
        }
        return null;
    }

    public static String getPackageName(PsiPackage psiPackage) {
        if (psiPackage == null) {
            return null;
        }
        String name = psiPackage.getQualifiedName();
        if (name.length() > 0) {
            return name;
        }
        return DEFAULT_PACKAGE_NAME;
    }

    public WordsScanner getWordsScanner() {
        return null;
    }
}

