/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ResourceUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;

public class DumpInspectionDescriptionsAction
extends AnAction
implements DumbAware {
    public DumpInspectionDescriptionsAction() {
        super("Dump inspection descriptions");
    }

    public void actionPerformed(AnActionEvent e) {
        InspectionProfile profile = (InspectionProfile)InspectionProfileManager.getInstance().getRootProfile();
        InspectionProfileEntry[] tools = profile.getInspectionTools(null);
        System.out.println("String[][] inspections = ");
        for (InspectionProfileEntry tool : tools) {
            String group = tool.getGroupDisplayName();
            if (group.length() == 0) {
                group = "General";
            }
            System.out.print("{\"" + group + "\", ");
            System.out.print("\"" + tool.getDisplayName() + "\", ");
            System.out.println("\"inspections/" + tool.getShortName() + ".html\"}, ");
            try {
                String description = ResourceUtil.loadText((URL)DumpInspectionDescriptionsAction.getDescriptionUrl(tool));
                FileWriter writer = new FileWriter("/Users/max/inspections/" + tool.getShortName() + ".html");
                writer.write(description);
                writer.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        System.out.println("};");
    }

    private static URL getDescriptionUrl(InspectionProfileEntry tool) {
        Class<?> aClass = tool instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)tool).getTool().getClass() : tool.getClass();
        return ResourceUtil.getResource(aClass, (String)"/inspectionDescriptions", (String)(tool.getShortName() + ".html"));
    }
}

