/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startupWizard.StartupWizard;
import com.intellij.idea.SocketLock;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;

public class StartupUtil {
    static boolean isHeadless;
    static SocketLock ourLock;
    private static String myDefaultLAF;

    private StartupUtil() {
    }

    public static void setDefaultLAF(String laf) {
        myDefaultLAF = laf;
    }

    public static String getDefaultLAF() {
        return myDefaultLAF;
    }

    public static boolean shouldShowSplash(String[] args) {
        String nosplashCode = "nosplash";
        return !Arrays.asList(args).contains("nosplash");
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    static boolean checkJdkVersion() {
        if (!"true".equals(System.getProperty("idea.no.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field");
            }
            catch (ClassNotFoundException e) {
                if (StartupUtil.isHeadless()) {
                    System.out.println("tools.jar is not in " + ApplicationNamesInfo.getInstance().getProductName() + " classpath. Please ensure JAVA_HOME points to JDK rather than JRE");
                    return false;
                }
                try {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "tools.jar is not in " + ApplicationNamesInfo.getInstance().getProductName() + " classpath. Please ensure JAVA_HOME points to JDK rather than JRE", "Error", 0);
                        }
                    };
                    if (EventQueue.isDispatchThread()) {
                        runnable.run();
                    } else {
                        EventQueue.invokeAndWait(runnable);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        if ("true".equals(System.getProperty("idea.no.jdk.check"))) {
            return true;
        }
        String version = System.getProperty("java.version");
        if (version.startsWith("1.5") || version.startsWith("1.6")) {
            return true;
        }
        StartupUtil.showVersionMismatch(version);
        return false;
    }

    private static void showVersionMismatch(String version) {
        if (StartupUtil.isHeadless()) {
            System.out.println("The JDK version is " + version + " but " + ApplicationNamesInfo.getInstance().getProductName() + " requires JDK 1.5 or 1.6");
            return;
        }
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "The JDK version is " + version + "\n" + ApplicationNamesInfo.getInstance().getProductName() + " requires JDK 1.5 or 1.6", "Java Version Mismatch", 1);
    }

    static synchronized boolean lockSystemFolders() {
        boolean locked;
        if (ourLock == null) {
            ourLock = new SocketLock();
        }
        boolean bl = locked = ourLock.lock(PathManager.getConfigPath((boolean)false)) && ourLock.lock(PathManager.getSystemPath());
        if (!locked) {
            if (StartupUtil.isHeadless()) {
                System.out.println("Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.");
                return false;
            }
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.", "Error", 1);
        }
        return locked;
    }

    static boolean checkStartupPossible() {
        return StartupUtil.checkJdkVersion() && StartupUtil.lockSystemFolders();
    }

    static void runStartupWizard() {
        List<ApplicationInfoEx.PluginChooserPage> pages = ApplicationInfoImpl.getShadowInstance().getPluginChooserPages();
        if (!pages.isEmpty()) {
            StartupWizard startupWizard = new StartupWizard(pages);
            startupWizard.setCancelText("Skip");
            startupWizard.show();
            PluginManager.invalidatePlugins();
        }
    }
}

