/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructureBase
extends AbstractTreeStructure {
    protected final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.AbstractTreeStructureBase");

    protected AbstractTreeStructureBase(Project project) {
        this.myProject = project;
    }

    public Object[] getChildElements(Object element) {
        LOG.assertTrue(element instanceof AbstractTreeNode, (Object)element.getClass().getName());
        AbstractTreeNode treeNode = (AbstractTreeNode)element;
        Collection elements = treeNode.getChildren();
        List<TreeStructureProvider> providers = this.getProvidersDumbAware();
        if (providers != null && !providers.isEmpty()) {
            for (TreeStructureProvider provider : providers) {
                elements = provider.modify(treeNode, elements, ViewSettings.DEFAULT);
            }
        }
        for (AbstractTreeNode node : elements) {
            node.setParent(treeNode);
        }
        return ArrayUtil.toObjectArray((Collection)elements);
    }

    public Object getParentElement(Object element) {
        if (element instanceof AbstractTreeNode) {
            return ((AbstractTreeNode)element).getParent();
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        NodeDescriptor nodeDescriptor = (NodeDescriptor)element;
        if (nodeDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeStructureBase.createDescriptor must not return null");
        }
        return nodeDescriptor;
    }

    @Nullable
    public abstract List<TreeStructureProvider> getProviders();

    public Object getDataFromProviders(List<AbstractTreeNode> selectedNodes, String dataId) {
        List<TreeStructureProvider> providers = this.getProvidersDumbAware();
        if (providers != null) {
            for (TreeStructureProvider treeStructureProvider : providers) {
                Object fromProvider = treeStructureProvider.getData(selectedNodes, dataId);
                if (fromProvider == null) continue;
                return fromProvider;
            }
        }
        return null;
    }

    private List<TreeStructureProvider> getProvidersDumbAware() {
        if (this.myProject == null) {
            return new ArrayList<TreeStructureProvider>();
        }
        List<TreeStructureProvider> providers = this.getProviders();
        if (providers == null) {
            return null;
        }
        return DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(providers);
    }
}

