/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.structureView.impl.java.FieldsFilter;
import com.intellij.ide.structureView.impl.java.InheritedMembersFilter;
import com.intellij.ide.structureView.impl.java.JavaFileTreeElement;
import com.intellij.ide.structureView.impl.java.KindSorter;
import com.intellij.ide.structureView.impl.java.PropertiesGrouper;
import com.intellij.ide.structureView.impl.java.PublicElementsFilter;
import com.intellij.ide.structureView.impl.java.SuperTypesGrouper;
import com.intellij.ide.structureView.impl.java.VisibilitySorter;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;

public class JavaFileTreeModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    private final PsiJavaFile myFile;

    public JavaFileTreeModel(@NotNull PsiJavaFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/structureView/impl/java/JavaFileTreeModel.<init> must not be null");
        }
        super((PsiFile)file);
        this.myFile = file;
    }

    @NotNull
    public Filter[] getFilters() {
        Filter[] filterArray = new Filter[]{new InheritedMembersFilter(), new FieldsFilter(), new PublicElementsFilter()};
        if (filterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/JavaFileTreeModel.getFilters must not return null");
        }
        return filterArray;
    }

    @NotNull
    public Grouper[] getGroupers() {
        Grouper[] grouperArray = new Grouper[]{new SuperTypesGrouper(), new PropertiesGrouper()};
        if (grouperArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/JavaFileTreeModel.getGroupers must not return null");
        }
        return grouperArray;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        JavaFileTreeElement javaFileTreeElement = new JavaFileTreeElement(this.myFile);
        if (javaFileTreeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/JavaFileTreeModel.getRoot must not return null");
        }
        return javaFileTreeElement;
    }

    public boolean shouldEnterElement(Object element) {
        return element instanceof PsiClass;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{KindSorter.INSTANCE, VisibilitySorter.INSTANCE, Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/JavaFileTreeModel.getSorters must not return null");
        }
        return sorterArray;
    }

    protected PsiFile getPsiFile() {
        return this.myFile;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof PsiClass || value instanceof PsiFile;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof PsiMethod || value instanceof PsiField;
    }

    protected boolean isSuitable(PsiElement element) {
        if (super.isSuitable(element)) {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiElement parent = method.getParent();
                if (parent instanceof PsiClass) {
                    return ((PsiClass)parent).getQualifiedName() != null;
                }
            } else if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiElement parent = field.getParent();
                if (parent instanceof PsiClass) {
                    return ((PsiClass)parent).getQualifiedName() != null;
                }
            } else if (element instanceof PsiClass) {
                return ((PsiClass)element).getQualifiedName() != null;
            }
        }
        return false;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        Class[] classArray = new Class[]{PsiClass.class, PsiMethod.class, PsiField.class, PsiJavaFile.class};
        if (classArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/JavaFileTreeModel.getSuitableClasses must not return null");
        }
        return classArray;
    }
}

