/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.java.AccessLevelProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;

public abstract class JavaClassTreeElementBase<Value extends PsiElement>
extends PsiTreeElementBase<Value>
implements AccessLevelProvider {
    private final boolean myIsInherited;

    protected JavaClassTreeElementBase(boolean isInherited, Value element) {
        super(element);
        this.myIsInherited = isInherited;
    }

    public boolean isInherited() {
        return this.myIsInherited;
    }

    public boolean isPublic() {
        Object element = this.getElement();
        return !(element instanceof PsiModifierListOwner) || ((PsiModifierListOwner)element).hasModifierProperty("public");
    }

    @Override
    public int getAccessLevel() {
        return PsiUtil.getAccessLevel((PsiModifierList)((PsiModifierListOwner)this.getElement()).getModifierList());
    }

    @Override
    public int getSubLevel() {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JavaClassTreeElementBase that = (JavaClassTreeElementBase)o;
        return this.myIsInherited == that.myIsInherited;
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return this.isDeprecated() ? CodeInsightColors.DEPRECATED_ATTRIBUTES : super.getTextAttributesKey();
    }

    private boolean isDeprecated() {
        Object element = this.getElement();
        return element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated();
    }
}

