/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModuleNode
extends ProjectViewNode<Module> {
    protected AbstractModuleNode(Project project, Module module, ViewSettings viewSettings) {
        super(project, (Object)module, viewSettings);
    }

    public void update(PresentationData presentation) {
        if (((Module)this.getValue()).isDisposed()) {
            this.setValue(null);
            return;
        }
        presentation.setPresentableText(((Module)this.getValue()).getName());
        if (this.showModuleNameInBold()) {
            presentation.addText(((Module)this.getValue()).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        presentation.setOpenIcon(((Module)this.getValue()).getModuleType().getNodeIcon(true));
        presentation.setClosedIcon(((Module)this.getValue()).getModuleType().getNodeIcon(false));
    }

    protected boolean showModuleNameInBold() {
        return true;
    }

    public String getTestPresentation() {
        return "Module";
    }

    public boolean contains(@NotNull VirtualFile file) {
        VirtualFile testee;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/AbstractModuleNode.contains must not be null");
        }
        Module module = (Module)this.getValue();
        if (module == null) {
            return false;
        }
        if (file.getFileSystem() instanceof JarFileSystem) {
            testee = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (testee == null) {
                return false;
            }
        } else {
            testee = file;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)testee, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public String getToolTip() {
        Module module = (Module)this.getValue();
        return module.getModuleType().getName();
    }

    public void navigate(boolean requestFocus) {
        ProjectSettingsService.getInstance(this.myProject).openModuleSettings((Module)this.getValue());
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }
}

