/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.palette.impl;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.palette.PaletteItem;
import com.intellij.ide.palette.impl.PaletteComponentList;
import com.intellij.ide.palette.impl.PaletteWindow;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.Nullable;

public class PaletteGroupHeader
extends JCheckBox
implements DataProvider {
    private final PaletteWindow myPaletteWindow;
    private PaletteComponentList myComponentList;
    private final PaletteGroup myGroup;

    public PaletteGroupHeader(PaletteWindow paletteWindow, PaletteGroup group) {
        this.myPaletteWindow = paletteWindow;
        this.myGroup = group;
        if (group.getName() == null) {
            this.setVisible(false);
        } else {
            this.setText(group.getName());
        }
        this.setSelected(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PaletteGroupHeader.this.myComponentList != null) {
                    PaletteGroupHeader.this.myComponentList.setVisible(PaletteGroupHeader.this.isSelected());
                }
            }
        });
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                PaletteGroupHeader.this.myPaletteWindow.setLastFocusedGroup(PaletteGroupHeader.this);
                PaletteGroupHeader.this.showGroupPopupMenu(comp, x, y);
            }
        });
        this.setIcon(UIUtil.getTreeCollapsedIcon());
        this.setSelectedIcon(UIUtil.getTreeExpandedIcon());
        this.setFont(this.getFont().deriveFont(1));
        this.setFocusPainted(false);
        this.setMargin(new Insets(0, 3, 0, 3));
        if (this.getBorder() instanceof CompoundBorder) {
            Dimension pref = this.getPreferredSize();
            pref.height -= 3;
            this.setPreferredSize(pref);
        }
        DnDManager.getInstance().registerTarget(new DnDTarget(){

            public boolean update(DnDEvent aEvent) {
                PaletteGroupHeader.this.setBorderPainted(true);
                aEvent.setDropPossible(aEvent.getAttachedObject() instanceof PaletteItem, null);
                return true;
            }

            public void drop(DnDEvent aEvent) {
                PaletteGroupHeader.this.setBorderPainted(false);
                if (aEvent.getAttachedObject() instanceof PaletteItem) {
                    PaletteGroupHeader.this.myGroup.handleDrop(PaletteGroupHeader.this.myPaletteWindow.getProject(), (PaletteItem)aEvent.getAttachedObject(), -1);
                }
            }

            public void cleanUpOnLeave() {
                PaletteGroupHeader.this.setBorderPainted(false);
            }

            public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            }
        }, (JComponent)this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaletteGroupHeader.this.myPaletteWindow.setLastFocusedGroup(PaletteGroupHeader.this);
            }
        });
        this.initActions();
    }

    public void showGroupPopupMenu(Component comp, int x, int y) {
        ActionGroup group = this.myGroup.getPopupActionGroup();
        if (group != null) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", group);
            popupMenu.getComponent().show(comp, x, y);
        }
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "moveFocusDown");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "moveFocusUp");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "collapse");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "expand");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("moveFocusDown", new MoveFocusAction(true));
        actionMap.put("moveFocusUp", new MoveFocusAction(false));
        actionMap.put("collapse", new ExpandAction(false));
        actionMap.put("expand", new ExpandAction(true));
    }

    @Override
    public Color getBackground() {
        if (this.isFocusOwner()) {
            return UIUtil.getListSelectionBackground();
        }
        return super.getBackground();
    }

    @Override
    public Color getForeground() {
        if (this.isFocusOwner()) {
            return UIUtil.getListSelectionForeground();
        }
        return super.getForeground();
    }

    public void setComponentList(PaletteComponentList componentList) {
        this.myComponentList = componentList;
    }

    public PaletteComponentList getComponentList() {
        return this.myComponentList;
    }

    public PaletteGroup getGroup() {
        return this.myGroup;
    }

    @Nullable
    public Object getData(String dataId) {
        Object data = this.myPaletteWindow.getData(dataId);
        if (data != null) {
            return data;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData((DataProvider)this.myPaletteWindow);
        return this.myGroup.getData(project, dataId);
    }

    private class ExpandAction
    extends AbstractAction {
        private final boolean expand;

        public ExpandAction(boolean expand) {
            this.expand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.expand == PaletteGroupHeader.this.isSelected()) {
                return;
            }
            PaletteGroupHeader.this.setSelected(this.expand);
            if (PaletteGroupHeader.this.myComponentList != null) {
                PaletteGroupHeader.this.myComponentList.setVisible(PaletteGroupHeader.this.isSelected());
            }
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private final boolean moveDown;

        public MoveFocusAction(boolean moveDown) {
            this.moveDown = moveDown;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component next;
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = kfm.getCurrentFocusCycleRoot();
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            if (null == policy) {
                policy = kfm.getDefaultFocusTraversalPolicy();
            }
            Component component = next = this.moveDown ? policy.getComponentAfter(container, PaletteGroupHeader.this) : policy.getComponentBefore(container, PaletteGroupHeader.this);
            if (null != next && next instanceof PaletteComponentList) {
                PaletteComponentList list = (PaletteComponentList)next;
                if (list.getModel().getSize() != 0) {
                    list.takeFocusFrom(PaletteGroupHeader.this, list == PaletteGroupHeader.this.myComponentList ? 0 : -1);
                    return;
                }
                Component component2 = next = this.moveDown ? policy.getComponentAfter(container, next) : policy.getComponentBefore(container, next);
            }
            if (null != next && next instanceof PaletteGroupHeader) {
                next.requestFocus();
            }
        }
    }
}

