/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.highlighter.WorkspaceFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.ProjectUtil");
    @NonNls
    public static final String DIRECTORY_BASED_PROJECT_DIR = ".idea";

    private ProjectUtil() {
    }

    public static void updateLastProjectLocation(String projectFilePath) {
        File lastProjectLocation = new File(projectFilePath);
        if (lastProjectLocation.isFile()) {
            lastProjectLocation = lastProjectLocation.getParentFile();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParentFile()) == null) {
            return;
        }
        String path = lastProjectLocation.getPath();
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        GeneralSettings.getInstance().setLastProjectLocation(path.replace(File.separatorChar, '/'));
    }

    public static boolean closeProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/impl/ProjectUtil.closeProject must not be null");
        }
        if (!ProjectManagerEx.getInstanceEx().closeProject(project)) {
            return false;
        }
        Disposer.dispose((Disposable)project);
        return true;
    }

    @Nullable
    public static Project openOrImport(@NotNull String path, Project projectToClose, boolean forceOpenInNewFrame) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/impl/ProjectUtil.openOrImport must not be null");
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        if (path.endsWith(".ipr") || virtualFile.isDirectory() && virtualFile.findChild(DIRECTORY_BASED_PROJECT_DIR) != null) {
            return ProjectUtil.openProject(path, projectToClose, forceOpenInNewFrame);
        }
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile);
        if (provider != null) {
            return provider.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
        }
        return null;
    }

    @Nullable
    public static Project openProject(String path, Project projectToClose, boolean forceOpenInNewFrame) {
        int exitCode;
        Project[] openProjects;
        File file = new File(path);
        if (!file.exists()) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{path}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return null;
        }
        if (file.isDirectory() && !new File(file, DIRECTORY_BASED_PROJECT_DIR).exists()) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{new File(file, DIRECTORY_BASED_PROJECT_DIR).getPath()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return null;
        }
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject(path, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return project;
        }
        if (!forceOpenInNewFrame && openProjects.length > 0 && ((exitCode = Messages.showDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String[])new String[]{IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), IdeBundle.message((String)"button.existingframe", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)1, (Icon)Messages.getQuestionIcon())) == 1 ? !ProjectUtil.closeProject(projectToClose != null ? projectToClose : openProjects[openProjects.length - 1]) : exitCode != 0)) {
            return null;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project project = null;
        try {
            project = projectManager.loadAndOpenProject(path);
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.is.corrupted", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidDataException e) {
            LOG.info((Throwable)e);
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.is.corrupted", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        return project;
    }

    private static boolean isSameProject(String path, Project p) {
        IProjectStore projectStore = ((ProjectEx)p).getStateStore();
        String toOpen = FileUtil.toSystemIndependentName((String)path);
        String existing = FileUtil.toSystemIndependentName((String)projectStore.getProjectFilePath());
        VirtualFile existingBaseDir = projectStore.getProjectBaseDir();
        if (existingBaseDir == null) {
            return false;
        }
        File openFile = new File(toOpen);
        if (openFile.isDirectory()) {
            return FileUtil.pathsEqual((String)toOpen, (String)existingBaseDir.getPath());
        }
        if (StorageScheme.DIRECTORY_BASED == projectStore.getStorageScheme()) {
            return FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)openFile.getParentFile().getPath()), (String)existingBaseDir.getPath());
        }
        return FileUtil.pathsEqual((String)toOpen, (String)existing);
    }

    public static void focusProjectWindow(final Project p, boolean executeIfAppInactive) {
        FocusCommand cmd = new FocusCommand(){

            public ActionCallback run() {
                JFrame f = WindowManager.getInstance().getFrame(p);
                if (f != null) {
                    f.toFront();
                }
                return new ActionCallback.Done();
            }
        };
        if (executeIfAppInactive) {
            cmd.run();
        } else {
            IdeFocusManager.getInstance((Project)p).requestFocus(cmd, false);
        }
    }

    public static boolean isProjectOrWorkspaceFile(VirtualFile file) {
        return ProjectUtil.isProjectOrWorkspaceFile(file, file.getFileType());
    }

    public static boolean isProjectOrWorkspaceFile(VirtualFile file, FileType fileType) {
        boolean iprBased;
        boolean bl = iprBased = fileType instanceof WorkspaceFileType || fileType instanceof ProjectFileType || fileType instanceof ModuleFileType;
        if (iprBased) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && parent.getName().equals(DIRECTORY_BASED_PROJECT_DIR);
    }
}

