/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class HtmlWebBrowserUrlProvider
extends WebBrowserUrlProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.browsers.HtmlWebBrowserUrlProvider");

    @NotNull
    public String getUrl(@NotNull PsiElement element, boolean shiftDown) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/browsers/HtmlWebBrowserUrlProvider.getUrl must not be null");
        }
        PsiFile file = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        String string = virtualFile.getUrl();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/browsers/HtmlWebBrowserUrlProvider.getUrl must not return null");
        }
        return string;
    }

    public boolean canHandleElement(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/browsers/HtmlWebBrowserUrlProvider.canHandleElement must not be null");
        }
        PsiFile psiFile = file = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        if (file == null) {
            return false;
        }
        Language language = file.getViewProvider().getBaseLanguage();
        return HTMLLanguage.INSTANCE == language || XHTMLLanguage.INSTANCE == language;
    }

    public static boolean isAvailableFor(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/browsers/HtmlWebBrowserUrlProvider.isAvailableFor must not be null");
        }
        Language language = file.getLanguage();
        return language instanceof HTMLLanguage || language instanceof XHTMLLanguage;
    }
}

