/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

abstract class GotoBookmarkActionBase
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware {
    protected GotoBookmarkActionBase() {
        super(false);
    }

    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/bookmarks/actions/GotoBookmarkActionBase.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/bookmarks/actions/GotoBookmarkActionBase.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/bookmarks/actions/GotoBookmarkActionBase.invoke must not be null");
        }
        if (ToolWindowManager.getInstance((Project)project).isEditorComponentActive()) {
            Bookmark bookmark = this.getBookmarkToGo(project, editor);
            if (bookmark == null) {
                return;
            }
            if (bookmark.getLine() >= editor.getDocument().getLineCount()) {
                return;
            }
            LogicalPosition pos = new LogicalPosition(bookmark.getLine(), 0);
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToLogicalPosition(pos);
            editor.getScrollingModel().scrollTo(new LogicalPosition(bookmark.getLine(), 0), ScrollType.CENTER);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected final boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        return this.getBookmarkToGo(project, editor) != null;
    }

    protected abstract Bookmark getBookmarkToGo(Project var1, Editor var2);
}

