/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ToolkitBugsProcessor {
    private static final Logger LOG = Logger.getInstance((String)"ToolkitBugProcessor");
    List<Handler> myHandlers = new ArrayList<Handler>();

    public ToolkitBugsProcessor() {
        Class<?>[] classes;
        for (Class<?> each : classes = this.getClass().getDeclaredClasses()) {
            if ((each.getModifiers() & 0x400) > 0 || !Handler.class.isAssignableFrom(each)) continue;
            try {
                Handler eachHandler = (Handler)each.newInstance();
                if (!eachHandler.isActual()) continue;
                this.myHandlers.add(eachHandler);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    public boolean process(Throwable e) {
        if (!Registry.is((String)"ide.consumeKnownToolkitBugs")) {
            return false;
        }
        StackTraceElement[] stack = e.getStackTrace();
        for (Handler each : this.myHandlers) {
            if (!each.process(e, stack)) continue;
            LOG.info("Ignored exception by toolkit bug processor, bug id=" + each.toString() + " desc=" + each.getDetails());
            return true;
        }
        return false;
    }

    static class Apple_ExceptionOnChangingMonitors
    extends Handler {
        Apple_ExceptionOnChangingMonitors() {
        }

        @Override
        boolean isActual() {
            return SystemInfo.isMac;
        }

        @Override
        boolean process(Throwable e, StackTraceElement[] stack) {
            if (e instanceof ArrayIndexOutOfBoundsException && stack.length > 1) {
                return stack[0].getClassName().equals("apple.awt.CWindow") && stack[0].getMethodName().equals("displayChanged");
            }
            return false;
        }

        @Override
        public String toString() {
            return "http://www.jetbrains.net/devnet/thread/278896";
        }
    }

    static class Tricky_JEditorPane_registerEditorKitForContentType_NPE
    extends Handler {
        Tricky_JEditorPane_registerEditorKitForContentType_NPE() {
            super("http://ea.jetbrains.com/browser/ea_problems/13587 - JEditorPane_registerEditorKitForContentType_NPE");
        }

        @Override
        boolean process(Throwable e, StackTraceElement[] stack) {
            if (e instanceof NullPointerException && stack.length > 3) {
                if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                    return false;
                }
                return stack[0].getClassName().equals("java.util.Hashtable") && stack[0].getMethodName().equals("put") && stack[3].getClassName().equals("javax.swing.JEditorPane") && stack[3].getMethodName().equals("loadDefaultKitsIfNecessary");
            }
            return false;
        }
    }

    static class Sun_6322854
    extends Handler {
        Sun_6322854() {
            super("NPE - Failed to retrieve atom name");
        }

        @Override
        boolean process(Throwable e, StackTraceElement[] stack) {
            if (e instanceof NullPointerException && stack.length > 2) {
                return e.getMessage() != null && e.getMessage().startsWith("Failed to retrieve atom name") && stack[1].getClassName().equals("sun.awt.X11.XAtom");
            }
            return false;
        }
    }

    static class Sun_6785663
    extends Handler {
        Sun_6785663() {
            super("Numbus L&F problem -- update style");
        }

        @Override
        boolean process(Throwable e, StackTraceElement[] stack) {
            if (e instanceof ClassCastException && stack.length > 1) {
                return stack[0].getClassName().equals("javax.swing.plaf.synth.SynthButtonUI") && stack[0].getMethodName().equals("updateStyle");
            }
            return false;
        }
    }

    static class Sun_6857057
    extends Handler {
        Sun_6857057() {
            super("text editor component - sync between model and view while dnd operations");
        }

        @Override
        public boolean process(Throwable e, StackTraceElement[] stack) {
            if (e instanceof ArrayIndexOutOfBoundsException && stack.length > 5) {
                return stack[0].getClassName().equals("sun.font.FontDesignMetrics") && stack[0].getMethodName().equals("charsWidth") && stack[5].getClassName().equals("javax.swing.text.CompositeView") && stack[5].getMethodName().equals("viewToModel");
            }
            return false;
        }
    }

    static abstract class Handler {
        private String myDetails;

        protected Handler() {
            this.myDetails = StringUtil.getShortName((String)this.getClass().getName());
        }

        protected Handler(String details) {
            this.myDetails = details;
        }

        abstract boolean process(Throwable var1, StackTraceElement[] var2);

        boolean isActual() {
            return true;
        }

        public String getDetails() {
            return this.myDetails;
        }

        public String toString() {
            String className = this.getClass().getName();
            String name = className.substring(className.lastIndexOf("$") + 1);
            if (name.startsWith("Sun_")) {
                name = name.substring("Sun_".length());
                return "http://bugs.sun.com/view_bug.do?bug_id=" + name;
            }
            return super.toString();
        }
    }
}

