/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecentProjectsManagerBase
implements PersistentStateComponent<State> {
    private State myState = new State();
    private static final int MAX_RECENT_PROJECTS = 15;

    public static RecentProjectsManagerBase getInstance() {
        return (RecentProjectsManagerBase)ApplicationManager.getApplication().getComponent(RecentProjectsManagerBase.class);
    }

    public RecentProjectsManagerBase(ProjectManager projectManager, MessageBus messageBus) {
        projectManager.addProjectManagerListener((ProjectManagerListener)new MyProjectManagerListener());
        messageBus.connect().subscribe(AppLifecycleListener.TOPIC, (Object)new MyAppLifecycleListener());
    }

    public State getState() {
        this.validateRecentProjects();
        return this.myState;
    }

    public void loadState(State state) {
        File lastFile;
        this.myState = state;
        if (this.myState.lastPath != null && !new File(this.myState.lastPath).exists()) {
            this.myState.lastPath = null;
        }
        if (this.myState.lastPath != null && (lastFile = new File(this.myState.lastPath)).isDirectory() && !new File(lastFile, ".idea").exists()) {
            this.myState.lastPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateRecentProjects() {
        State state = this.myState;
        synchronized (state) {
            Iterator<String> i = this.myState.recentPaths.iterator();
            while (i.hasNext()) {
                String s = i.next();
                if (s == null) {
                    i.remove();
                    continue;
                }
                File file = new File(s);
                if (file.isDirectory()) {
                    if (new File(file, ".idea").exists()) continue;
                    i.remove();
                    continue;
                }
                if (file.exists()) continue;
                i.remove();
            }
            while (this.myState.recentPaths.size() > 15) {
                this.myState.recentPaths.remove(this.myState.recentPaths.size() - 1);
            }
        }
    }

    private void removePath(String path) {
        if (path == null) {
            return;
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            this.myState.recentPaths.remove(path);
        } else {
            Iterator<String> i = this.myState.recentPaths.iterator();
            while (i.hasNext()) {
                String p = i.next();
                if (!path.equalsIgnoreCase(p)) continue;
                i.remove();
            }
        }
    }

    public String getLastProjectPath() {
        return this.myState.lastPath;
    }

    public void updateLastProjectPath() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        this.myState.lastPath = openProjects.length == 0 ? null : this.getProjectPath(openProjects[openProjects.length - 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnAction[] getRecentProjectsActions(boolean addClearListItem) {
        this.validateRecentProjects();
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        ArrayList<ReopenProjectAction> actions = new ArrayList<ReopenProjectAction>();
        State state = this.myState;
        synchronized (state) {
            block3: for (String string : this.myState.recentPaths) {
                for (Project openProject : openProjects) {
                    String path = this.getProjectPath(openProject);
                    if (path == null || string.equals(path)) continue block3;
                }
                actions.add(new ReopenProjectAction(string));
            }
        }
        if (actions.size() == 0) {
            return new AnAction[0];
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (AnAction anAction : actions) {
            list.add(anAction);
        }
        if (addClearListItem) {
            AnAction clearListAction = new AnAction(IdeBundle.message((String)"action.clear.list", (Object[])new Object[0])){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(AnActionEvent e) {
                    int rc = Messages.showOkCancelDialog((Project)((Project)e.getData(PlatformDataKeys.PROJECT)), (String)"Would you like to clear the list of recent projects?", (String)"Clear Recent Projects List", (Icon)Messages.getQuestionIcon());
                    if (rc == 0) {
                        State state = RecentProjectsManagerBase.this.myState;
                        synchronized (state) {
                            ((RecentProjectsManagerBase)RecentProjectsManagerBase.this).myState.recentPaths.clear();
                        }
                    }
                }
            };
            list.add(Separator.getInstance());
            list.add(clearListAction);
        }
        return list.toArray(new AnAction[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markPathRecent(String path) {
        State state = this.myState;
        synchronized (state) {
            this.myState.lastPath = path;
            this.removePath(path);
            this.myState.recentPaths.add(0, path);
        }
    }

    @Nullable
    protected abstract String getProjectPath(Project var1);

    protected abstract void doOpenProject(String var1, Project var2);

    private class MyAppLifecycleListener
    extends AppLifecycleListener.Adapter {
        private MyAppLifecycleListener() {
        }

        @Override
        public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
            if (willOpenProject == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/RecentProjectsManagerBase$MyAppLifecycleListener.appFrameCreated must not be null");
            }
            if (GeneralSettings.getInstance().isReopenLastProject() && RecentProjectsManagerBase.this.getLastProjectPath() != null) {
                willOpenProject.set((Object)Boolean.TRUE);
            }
        }

        @Override
        public void appStarting(Project projectFromCommandLine) {
            String lastProjectPath;
            if (projectFromCommandLine != null) {
                return;
            }
            GeneralSettings generalSettings = GeneralSettings.getInstance();
            if (generalSettings.isReopenLastProject() && (lastProjectPath = RecentProjectsManagerBase.this.getLastProjectPath()) != null) {
                RecentProjectsManagerBase.this.doOpenProject(lastProjectPath, null);
            }
        }

        @Override
        public void projectFrameClosed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void projectOpenFailed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }
    }

    private class ReopenProjectAction
    extends AnAction
    implements DumbAware {
        private final String myProjectPath;

        public ReopenProjectAction(String projectPath) {
            this.myProjectPath = projectPath;
            this.getTemplatePresentation().setText(projectPath, false);
        }

        public void actionPerformed(AnActionEvent e) {
            RecentProjectsManagerBase.this.doOpenProject(this.myProjectPath, (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext()));
        }
    }

    private class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectOpened(Project project) {
            String path = RecentProjectsManagerBase.this.getProjectPath(project);
            RecentProjectsManagerBase.this.markPathRecent(path);
        }

        public void projectClosed(Project project) {
            String path;
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            if (openProjects.length > 0 && (path = RecentProjectsManagerBase.this.getProjectPath(openProjects[openProjects.length - 1])) != null) {
                RecentProjectsManagerBase.this.markPathRecent(path);
            }
        }
    }

    public static class State {
        public List<String> recentPaths = new ArrayList<String>();
        public String lastPath;
    }
}

