/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.Nullable;

public class JavaFilePasteProvider
implements PasteProvider {
    public void performPaste(DataContext dataContext) {
        final Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)DataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || ideView == null) {
            return;
        }
        final PsiJavaFile javaFile = JavaFilePasteProvider.createJavaFileFromClipboardContent(project);
        if (javaFile == null) {
            return;
        }
        final PsiClass[] classes = javaFile.getClasses();
        if (classes.length != 1) {
            return;
        }
        final PsiDirectory targetDir = ideView.getOrChooseDirectory();
        if (targetDir == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiFile file;
                try {
                    file = targetDir.createFile(classes[0].getName() + ".java");
                }
                catch (IncorrectOperationException e) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                document.setText((CharSequence)javaFile.getText());
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                if (file instanceof PsiJavaFile) {
                    JavaFilePasteProvider.updatePackageStatement((PsiJavaFile)file, targetDir);
                }
                new OpenFileDescriptor(project, file.getVirtualFile()).navigate(true);
            }
        });
    }

    private static void updatePackageStatement(final PsiJavaFile javaFile, PsiDirectory targetDir) {
        final PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDir);
        if (aPackage == null) {
            return;
        }
        final PsiPackageStatement oldStatement = javaFile.getPackageStatement();
        final Project project = javaFile.getProject();
        if (oldStatement != null && !oldStatement.getPackageName().equals(aPackage.getQualifiedName()) || oldStatement == null && aPackage.getQualifiedName().length() > 0) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    try {
                        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                        PsiPackageStatement newStatement = factory.createPackageStatement(aPackage.getQualifiedName());
                        if (oldStatement != null) {
                            oldStatement.replace((PsiElement)newStatement);
                        } else {
                            PsiElement addedStatement = javaFile.addAfter((PsiElement)newStatement, null);
                            TextRange textRange = addedStatement.getTextRange();
                            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)javaFile, textRange.getStartOffset(), textRange.getEndOffset() + 1);
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                }
            }, "Updating package statement", null);
        }
    }

    public boolean isPastePossible(DataContext dataContext) {
        return true;
    }

    public boolean isPasteEnabled(DataContext dataContext) {
        Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)DataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || ideView == null || ideView.getDirectories().length == 0) {
            return false;
        }
        PsiJavaFile file = JavaFilePasteProvider.createJavaFileFromClipboardContent(project);
        return file != null && file.getClasses().length == 1;
    }

    @Nullable
    private static PsiJavaFile createJavaFileFromClipboardContent(Project project) {
        PsiJavaFile file = null;
        Transferable content = CopyPasteManager.getInstance().getContents();
        if (content != null) {
            String text = null;
            try {
                text = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (text != null) {
                file = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText("A.java", StdLanguages.JAVA, (CharSequence)text);
            }
        }
        return file;
    }
}

