/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.Patches;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.CutElementMarker;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.EventDispatcher;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CopyPasteManagerEx
extends CopyPasteManager
implements ClipboardOwner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.CopyPasteManagerEx");
    private final ArrayList<Transferable> myDatas;
    private final EventDispatcher<CopyPasteManager.ContentChangedListener> myDispatcher = EventDispatcher.create(CopyPasteManager.ContentChangedListener.class);
    private static final int DELAY_UNTIL_ABORT_CLIPBOARD_ACCESS = 2000;
    private boolean myIsWarningShown = false;

    public CopyPasteManagerEx() {
        this.myDatas = new ArrayList();
    }

    public Transferable getSystemClipboardContents() {
        final Transferable[] contents = new Transferable[]{null};
        final boolean[] success = new boolean[]{false};
        Runnable accessor = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            contents[0] = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(CopyPasteManagerEx.this);
                            break;
                        }
                        catch (IllegalStateException e) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    success[0] = true;
                }
                catch (Throwable throwable) {
                }
                finally {
                    Thread.interrupted();
                }
            }
        };
        if (Patches.SUN_BUG_ID_4818143) {
            Future accessorFuture = ApplicationManager.getApplication().executeOnPooledThread(accessor);
            try {
                accessorFuture.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
            }
            catch (TimeoutException e) {
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            if (success[0]) {
                return contents[0];
            }
            accessorFuture.cancel(true);
            this.showWorkaroundMessage();
            return null;
        }
        accessor.run();
        return contents[0];
    }

    private void showWorkaroundMessage() {
        if (this.myIsWarningShown) {
            return;
        }
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        Messages.showErrorDialog((String)IdeBundle.message((String)"error.paste.bug.workaround", (Object[])new Object[]{productName, productName}), (String)IdeBundle.message((String)"title.system.error", (Object[])new Object[0]));
        this.myIsWarningShown = true;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.fireContentChanged(null);
    }

    void fireContentChanged(Transferable oldTransferable) {
        ((CopyPasteManager.ContentChangedListener)this.myDispatcher.getMulticaster()).contentChanged(oldTransferable, this.getContents());
    }

    public void addContentChangedListener(CopyPasteManager.ContentChangedListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addContentChangedListener(CopyPasteManager.ContentChangedListener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void removeContentChangedListener(CopyPasteManager.ContentChangedListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void setContents(Transferable content) {
        Transferable old = this.getContents();
        this.addNewContentToStack(content);
        this.setSystemClipboardContent(content);
        this.fireContentChanged(old);
    }

    public boolean isCutElement(Object element) {
        for (CutElementMarker marker : (CutElementMarker[])Extensions.getExtensions((ExtensionPointName)CutElementMarker.EP_NAME)) {
            if (!marker.isCutElement(element)) continue;
            return true;
        }
        return false;
    }

    void setSystemClipboardContent(final Transferable content) {
        final boolean[] success = new boolean[]{false};
        Runnable accessor = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(content, CopyPasteManagerEx.this);
                            break;
                        }
                        catch (IllegalStateException e) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    success[0] = true;
                }
                finally {
                    Thread.interrupted();
                }
            }
        };
        if (Patches.SUN_BUG_ID_4818143) {
            Future accessorFuture = ApplicationManager.getApplication().executeOnPooledThread(accessor);
            try {
                accessorFuture.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!success[0]) {
                this.showWorkaroundMessage();
                accessorFuture.cancel(true);
            }
        } else {
            accessor.run();
        }
    }

    private void addNewContentToStack(Transferable content) {
        try {
            String clipString = CopyPasteManagerEx.getStringContent(content);
            if (clipString != null) {
                Transferable same = null;
                for (Transferable old : this.myDatas) {
                    if (!clipString.equals(CopyPasteManagerEx.getStringContent(old))) continue;
                    same = old;
                    break;
                }
                if (same == null) {
                    this.myDatas.add(0, content);
                    this.deleteAfterAllowedMaximum();
                } else {
                    this.moveContentTopStackTop(same);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getStringContent(Transferable content) throws UnsupportedFlavorException, IOException {
        return (String)content.getTransferData(DataFlavor.stringFlavor);
    }

    private void deleteAfterAllowedMaximum() {
        int max = UISettings.getInstance().MAX_CLIPBOARD_CONTENTS;
        for (int i = this.myDatas.size() - 1; i >= max; --i) {
            this.myDatas.remove(i);
        }
    }

    public Transferable getContents() {
        return this.getSystemClipboardContents();
    }

    public Transferable[] getAllContents() {
        this.deleteAfterAllowedMaximum();
        Transferable content = this.getSystemClipboardContents();
        if (content != null) {
            try {
                String clipString = CopyPasteManagerEx.getStringContent(content);
                String datasString = null;
                if (!this.myDatas.isEmpty()) {
                    datasString = CopyPasteManagerEx.getStringContent(this.myDatas.get(0));
                }
                if (clipString != null && clipString.length() > 0 && !Comparing.equal((String)clipString, (String)datasString)) {
                    this.myDatas.add(0, content);
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.myDatas.toArray(new Transferable[this.myDatas.size()]);
    }

    public void removeContent(Transferable t) {
        Transferable old = this.getContents();
        boolean isCurrentClipboardContent = this.myDatas.indexOf(t) == 0;
        this.myDatas.remove(t);
        if (isCurrentClipboardContent) {
            if (!this.myDatas.isEmpty()) {
                this.setSystemClipboardContent(this.myDatas.get(0));
            } else {
                this.setSystemClipboardContent(new StringSelection(""));
            }
        }
        this.fireContentChanged(old);
    }

    public void moveContentTopStackTop(Transferable t) {
        this.setSystemClipboardContent(t);
        this.myDatas.remove(t);
        this.myDatas.add(0, t);
    }
}

