/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.FragmentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;

public class SelectionDifferenceModel
extends FileDifferenceModel {
    private final SelectionCalculator myCalculator;
    private final Revision myLeftRevision;
    private final Revision myRightRevision;
    private final int myFrom;
    private final int myTo;

    public SelectionDifferenceModel(IdeaGateway gw, SelectionCalculator c, Revision left, Revision right, int from, int to, boolean editableRightContent) {
        super(gw, editableRightContent);
        this.myCalculator = c;
        this.myLeftRevision = left;
        this.myRightRevision = right;
        this.myFrom = from;
        this.myTo = to;
    }

    @Override
    protected Entry getLeftEntry() {
        return this.myLeftRevision.getEntry();
    }

    @Override
    protected Entry getRightEntry() {
        return this.myRightRevision.getEntry();
    }

    @Override
    protected boolean isLeftContentAvailable(RevisionProcessingProgress p) {
        return this.myCalculator.canCalculateFor(this.myLeftRevision, p);
    }

    @Override
    protected boolean isRightContentAvailable(RevisionProcessingProgress p) {
        return this.myCalculator.canCalculateFor(this.myRightRevision, p);
    }

    @Override
    protected DiffContent doGetLeftDiffContent(RevisionProcessingProgress p) {
        return this.getDiffContent(this.myLeftRevision, p);
    }

    @Override
    protected DiffContent getReadOnlyRightDiffContent(RevisionProcessingProgress p) {
        return this.getDiffContent(this.myRightRevision, p);
    }

    @Override
    protected DiffContent getEditableRightDiffContent(RevisionProcessingProgress p) {
        Document d = this.getDocument();
        int fromOffset = d.getLineStartOffset(this.myFrom);
        int toOffset = d.getLineEndOffset(this.myTo);
        return FragmentContent.fromRangeMarker((RangeMarker)d.createRangeMarker(fromOffset, toOffset), (Project)this.getProject());
    }

    private SimpleContent getDiffContent(Revision r, RevisionProcessingProgress p) {
        return this.createSimpleDiffContent(this.getContentOf(r, p), r.getEntry());
    }

    private String getContentOf(Revision r, RevisionProcessingProgress p) {
        return this.myCalculator.getSelectionFor(r, p).getBlockContent();
    }
}

