/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.impl.autodetecting.DisabledAutodetectionByTypeElement;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisabledAutodetectionInfo {
    private List<DisabledAutodetectionByTypeElement> myElements = new ArrayList<DisabledAutodetectionByTypeElement>();

    @Tag(value="autodetection-disabled")
    @AbstractCollection(surroundWithTag=false)
    public List<DisabledAutodetectionByTypeElement> getElements() {
        return this.myElements;
    }

    public void setElements(List<DisabledAutodetectionByTypeElement> elements) {
        this.myElements = elements;
    }

    public boolean isDisabled(@NotNull String facetType, @NotNull String moduleName, String url) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.isDisabled must not be null");
        }
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.isDisabled must not be null");
        }
        DisabledAutodetectionByTypeElement element = this.findElement(facetType);
        return element != null && element.isDisabled(moduleName, url);
    }

    public void replaceElement(@NotNull String facetTypeId, @Nullable DisabledAutodetectionByTypeElement element) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.replaceElement must not be null");
        }
        Iterator<DisabledAutodetectionByTypeElement> iterator = this.myElements.iterator();
        while (iterator.hasNext()) {
            DisabledAutodetectionByTypeElement typeElement = iterator.next();
            if (!typeElement.getFacetTypeId().equals(facetTypeId)) continue;
            iterator.remove();
            break;
        }
        if (element != null) {
            this.myElements.add(element);
        }
    }

    @Nullable
    public DisabledAutodetectionByTypeElement findElement(@NotNull String facetTypeId) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.findElement must not be null");
        }
        for (DisabledAutodetectionByTypeElement element : this.myElements) {
            if (!facetTypeId.equals(element.getFacetTypeId())) continue;
            return element;
        }
        return null;
    }

    public void addDisabled(@NotNull String facetTypeId) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.addDisabled must not be null");
        }
        DisabledAutodetectionByTypeElement element = this.findElement(facetTypeId);
        if (element != null) {
            element.disableInProject();
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.addDisabled must not be null");
        }
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.addDisabled must not be null");
        }
        DisabledAutodetectionByTypeElement element = this.findElement(facetTypeId);
        if (element != null) {
            element.addDisabled(moduleName);
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId, moduleName));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName, String url, boolean recursively) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.addDisabled must not be null");
        }
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.addDisabled must not be null");
        }
        DisabledAutodetectionByTypeElement element = this.findElement(facetTypeId);
        if (element != null) {
            element.addDisabled(moduleName, url, recursively);
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId, moduleName, url, recursively));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName, String ... urls) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.addDisabled must not be null");
        }
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.addDisabled must not be null");
        }
        if (urls == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionInfo.addDisabled must not be null");
        }
        for (String url : urls) {
            this.addDisabled(facetTypeId, moduleName, url, false);
        }
    }
}

