/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.StubPath;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class StubPathBuilder {
    private StubPathBuilder() {
    }

    public static StubPath build(StubBasedPsiElement psi) {
        if (psi instanceof PsiFile) {
            return null;
        }
        StubElement liveStub = psi.getStub();
        if (liveStub != null) {
            return StubPathBuilder.build(liveStub);
        }
        return (StubPath)StubPathBuilder.buildForPsi((PsiElement)psi, ((PsiFileImpl)psi.getContainingFile()).calcStubTree()).getFirst();
    }

    public static StubPath build(StubElement stub) {
        if (stub instanceof PsiFileStub || stub == null) {
            return null;
        }
        IStubElementType type = stub.getStubType();
        return new StubPath(StubPathBuilder.build(stub.getParentStub()), type.getId(stub), (IElementType)type);
    }

    private static Pair<StubPath, StubElement> buildForPsi(PsiElement psi, StubTree tree) {
        IStubElementType type;
        if (psi instanceof PsiFile) {
            return new Pair(null, (Object)tree.getRoot());
        }
        if (psi instanceof StubBasedPsiElement && (type = ((StubBasedPsiElement)psi).getElementType()).shouldCreateStub(psi.getNode())) {
            Pair<StubPath, StubElement> parentPair = StubPathBuilder.buildForPsi(psi.getParent(), tree);
            StubElement parentStub = (StubElement)parentPair.getSecond();
            List childrenStubs = parentStub.getChildrenStubs();
            for (StubElement childStub : childrenStubs) {
                if (childStub.getPsi() != psi) continue;
                IStubElementType type1 = childStub.getStubType();
                return new Pair((Object)new StubPath((StubPath)parentPair.getFirst(), type1.getId(childStub), (IElementType)type1), (Object)childStub);
            }
            return new Pair(null, null);
        }
        return StubPathBuilder.buildForPsi(psi.getParent(), tree);
    }

    @Nullable
    public static PsiElement resolve(PsiFile file, StubPath path) {
        boolean foreign;
        PsiFileImpl fileImpl = (PsiFileImpl)file;
        StubTree tree = fileImpl.getStubTree();
        boolean bl = foreign = tree == null;
        if (foreign) {
            tree = fileImpl.calcStubTree();
        }
        StubElement stub = StubPathBuilder.resolveStub(tree, path);
        if (foreign) {
            PsiElement cachedPsi = ((StubBase)stub).getCachedPsi();
            if (cachedPsi != null) {
                return cachedPsi;
            }
            ASTNode ast = fileImpl.findTreeForStub(tree, stub);
            return ast != null ? ast.getPsi() : null;
        }
        return stub != null ? stub.getPsi() : null;
    }

    @Nullable
    public static StubElement resolveStub(StubTree tree, StubPath path) {
        if (path == null) {
            return tree.getRoot();
        }
        StubElement parentStub = StubPathBuilder.resolveStub(tree, path.getParentPath());
        if (parentStub == null) {
            return null;
        }
        String id = path.getId();
        IStubElementType type = (IStubElementType)path.getType();
        List children = parentStub.getChildrenStubs();
        if (id.startsWith("#")) {
            int count = Integer.parseInt(id.substring(1));
            for (StubElement child : children) {
                if (child.getStubType() != type || --count != 0) continue;
                return child;
            }
            return null;
        }
        for (StubElement child : children) {
            if (child.getStubType() != type || !id.equals(type.getId(child))) continue;
            return child;
        }
        return null;
    }
}

