/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteProcessSupport<Target, EntryPoint, Parameters> {
    private final Project myProject;
    private final Class<EntryPoint> myValueClass;
    private final HashMap<Pair<Target, Parameters>, Object> myProcMap = new HashMap();

    public RemoteProcessSupport(Project project, Class<EntryPoint> valueClass) {
        this.myProject = project;
        this.myValueClass = valueClass;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected abstract void fireModificationCountChanged();

    protected abstract String getName(Target var1);

    protected void logText(Parameters configuration, ProcessEvent event, Key outputType, Object info) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        ArrayList allHandlers = new ArrayList();
        HashMap<Pair<Target, Parameters>, Object> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Object o : this.myProcMap.values()) {
                ProcessHandler handler = o instanceof PendingInfo ? ((PendingInfo)o).handler : (o instanceof Info ? ((Info)o).handler : null);
                ContainerUtil.addIfNotNull((Object)handler, allHandlers);
            }
            this.myProcMap.clear();
        }
        for (ProcessHandler handler : allHandlers) {
            handler.destroyProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Parameters> getActiveConfigurations(@NotNull Target target) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/rmi/RemoteProcessSupport.getActiveConfigurations must not be null");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<Pair<Target, Parameters>, Object> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> pair : this.myProcMap.keySet()) {
                if (pair.first != target) continue;
                result.add(pair.second);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPoint acquire(@NotNull Target target, @NotNull Parameters configuration) throws Exception {
        Pair key;
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/rmi/RemoteProcessSupport.acquire must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/rmi/RemoteProcessSupport.acquire must not be null");
        }
        Ref ref = Ref.create(null);
        if (!this.getExistingInfo((Ref<Info>)ref, key = Pair.create(target, configuration))) {
            this.startProcess(target, configuration, key);
            if (ref.isNull()) {
                try {
                    Ref ref2 = ref;
                    synchronized (ref2) {
                        while (ref.isNull()) {
                            ref.wait(1000L);
                            ProgressManager.checkCanceled();
                        }
                    }
                }
                catch (InterruptedException e) {
                    ProgressManager.checkCanceled();
                }
            }
        }
        if (ref.isNull()) {
            throw new RuntimeException("Unable to acquire remote proxy for: " + this.getName(target));
        }
        Info info = (Info)ref.get();
        if (info.handler == null) {
            throw new RuntimeException(info.name);
        }
        return this.acquire(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@NotNull Target target, @Nullable Parameters configuration) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/rmi/RemoteProcessSupport.release must not be null");
        }
        ArrayList<ProcessHandler> handlersToStop = new ArrayList<ProcessHandler>();
        ArrayList<Pair<Target, Parameters>> keysToRemove = new ArrayList<Pair<Target, Parameters>>();
        HashMap<Pair<Target, Parameters>, Object> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> pair : this.myProcMap.keySet()) {
                Object o;
                ProcessHandler handler;
                if (pair.first != target || configuration != null && pair.second != configuration || (handler = (o = this.myProcMap.get(pair)) instanceof PendingInfo ? ((PendingInfo)o).handler : (o instanceof Info ? ((Info)o).handler : null)) == null) continue;
                handlersToStop.add(handler);
                keysToRemove.add(pair);
            }
            this.myProcMap.keySet().removeAll(keysToRemove);
        }
        for (ProcessHandler handler : handlersToStop) {
            handler.destroyProcess();
        }
        this.fireModificationCountChanged();
    }

    private void startProcess(Target target, Parameters configuration, Pair<Target, Parameters> key) {
        DefaultProgramRunner runner = new DefaultProgramRunner(){

            @NotNull
            public String getRunnerId() {
                if ("MyRunner" == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/execution/rmi/RemoteProcessSupport$1.getRunnerId must not return null");
                }
                return "MyRunner";
            }

            public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
                if (executorId == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/rmi/RemoteProcessSupport$1.canRun must not be null");
                }
                if (profile == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/rmi/RemoteProcessSupport$1.canRun must not be null");
                }
                return true;
            }
        };
        try {
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            RunProfileState state = this.getRunProfileState(target, configuration, executor);
            ExecutionResult result = state.execute(executor, (ProgramRunner)runner);
            ProcessHandler processHandler = result.getProcessHandler();
            processHandler.addProcessListener(this.getProcessListener(key));
            processHandler.startNotify();
        }
        catch (ExecutionException e) {
            this.handleProcessTerminated(key, e.getMessage());
        }
    }

    protected abstract RunProfileState getRunProfileState(Target var1, Parameters var2, Executor var3) throws ExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getExistingInfo(Ref<Info> ref, Pair<Target, Parameters> key) {
        Object info;
        HashMap<Pair<Target, Parameters>, Object> hashMap = this.myProcMap;
        synchronized (hashMap) {
            info = this.myProcMap.get(key);
            try {
                while (info != null && (!(info instanceof Info) || ((Info)info).handler.isProcessTerminating() || ((Info)info).handler.isProcessTerminated())) {
                    this.myProcMap.wait(1000L);
                    ProgressManager.checkCanceled();
                    info = this.myProcMap.get(key);
                }
            }
            catch (InterruptedException e) {
                ProgressManager.checkCanceled();
            }
            if (info == null) {
                this.myProcMap.put(key, new PendingInfo(ref, null));
            }
        }
        if (info != null) {
            if (info instanceof Info) {
                hashMap = ref;
                synchronized (hashMap) {
                    ref.set((Object)((Info)info));
                    ref.notifyAll();
                }
            }
            return true;
        }
        return false;
    }

    private EntryPoint acquire(final Info port) throws Exception {
        return (EntryPoint)RemoteUtil.executeWithClassLoader(new ThrowableComputable<EntryPoint, Exception>(){

            public EntryPoint compute() throws Exception {
                Remote remote = LocateRegistry.getRegistry(port.port).lookup(port.name);
                if (Remote.class.isAssignableFrom(RemoteProcessSupport.this.myValueClass)) {
                    return RemoteUtil.substituteClassLoader(RemoteProcessSupport.narrowImpl(remote, RemoteProcessSupport.this.myValueClass), RemoteProcessSupport.this.myValueClass.getClassLoader());
                }
                return RemoteUtil.castToLocal(remote, RemoteProcessSupport.this.myValueClass);
            }
        }, this.getClass().getClassLoader());
    }

    private static <T> T narrowImpl(Remote remote, Class<T> to) {
        return (T)(to.isInstance(remote) ? remote : PortableRemoteObject.narrow((Object)remote, to));
    }

    private ProcessListener getProcessListener(final Pair<Target, Parameters> key) {
        return new ProcessListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                ProcessHandler processHandler = event.getProcessHandler();
                processHandler.putUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE, (Object)Boolean.TRUE);
                HashMap hashMap = RemoteProcessSupport.this.myProcMap;
                synchronized (hashMap) {
                    Object o = RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        RemoteProcessSupport.this.myProcMap.put(key, new PendingInfo(((PendingInfo)o).ref, processHandler));
                    }
                }
            }

            public void processTerminated(ProcessEvent event) {
                RemoteProcessSupport.this.handleProcessTerminated(key, null);
                RemoteProcessSupport.this.fireModificationCountChanged();
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                PendingInfo info;
                Info result = null;
                Ref<Info> ref = RemoteProcessSupport.this.myProcMap;
                synchronized (ref) {
                    Object o = RemoteProcessSupport.this.myProcMap.get(key);
                    RemoteProcessSupport.this.logText(key.second, event, outputType, o);
                    if (o instanceof PendingInfo) {
                        info = (PendingInfo)o;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            String text = event.getText();
                            String prefix = "Port/ID:";
                            if (text != null && text.startsWith("Port/ID:")) {
                                String pair = text.substring("Port/ID:".length()).trim();
                                int idx = pair.indexOf("/");
                                result = new Info(info.handler, Integer.parseInt(pair.substring(0, idx)), pair.substring(idx + 1));
                                RemoteProcessSupport.this.myProcMap.put(key, result);
                                RemoteProcessSupport.this.myProcMap.notifyAll();
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            info.stderr.append(event.getText());
                        }
                    } else {
                        info = null;
                    }
                }
                if (result != null) {
                    ref = info.ref;
                    synchronized (ref) {
                        info.ref.set(result);
                        info.ref.notifyAll();
                    }
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessTerminated(Pair<Target, Parameters> key, String errorMessage) {
        PendingInfo pendingInfo;
        HashMap<Pair<Target, Parameters>, Object> hashMap = this.myProcMap;
        synchronized (hashMap) {
            Object o = this.myProcMap.remove(key);
            PendingInfo pendingInfo2 = pendingInfo = o instanceof PendingInfo ? (PendingInfo)o : null;
            if (pendingInfo != null && (pendingInfo.stderr.length() > 0 || pendingInfo.ref.isNull())) {
                if (errorMessage != null) {
                    pendingInfo.stderr.append(errorMessage);
                }
                pendingInfo.ref.set((Object)new Info(null, -1, pendingInfo.stderr.toString()));
            }
            this.myProcMap.notifyAll();
        }
        if (pendingInfo != null) {
            hashMap = pendingInfo.ref;
            synchronized (hashMap) {
                pendingInfo.ref.notifyAll();
            }
        }
    }

    private static class Info {
        final ProcessHandler handler;
        final int port;
        final String name;

        private Info(ProcessHandler handler, int port, String name) {
            this.handler = handler;
            this.port = port;
            this.name = name;
        }
    }

    private static class PendingInfo {
        final Ref<Info> ref;
        final ProcessHandler handler;
        final StringBuilder stderr = new StringBuilder();

        private PendingInfo(Ref<Info> ref, ProcessHandler handler) {
            this.ref = ref;
            this.handler = handler;
        }
    }
}

