/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.PreferedProducerFind;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ConfigurationContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.actions.ConfigurationContext");
    private final Location<PsiElement> myLocation;
    private RunnerAndConfigurationSettingsImpl myConfiguration;
    private final Module myModule;
    private final RuntimeConfiguration myRuntimeConfiguration;
    private final Component myContextComponent;

    public ConfigurationContext(DataContext dataContext) {
        this.myRuntimeConfiguration = (RuntimeConfiguration)RuntimeConfiguration.DATA_KEY.getData(dataContext);
        this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        this.myModule = (Module)LangDataKeys.MODULE.getData(dataContext);
        Location location = (Location)Location.DATA_KEY.getData(dataContext);
        if (location != null) {
            this.myLocation = location;
            return;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            this.myLocation = null;
            return;
        }
        PsiElement element = ConfigurationContext.getSelectedPsiElement(dataContext, project);
        if (element == null) {
            this.myLocation = null;
            return;
        }
        this.myLocation = new PsiLocation(project, this.myModule, element);
    }

    public RunnerAndConfigurationSettingsImpl getConfiguration() {
        if (this.myConfiguration == null) {
            this.createConfiguration();
        }
        return this.myConfiguration;
    }

    private void createConfiguration() {
        LOG.assertTrue(this.myConfiguration == null);
        Location location = this.getLocation();
        this.myConfiguration = location != null ? PreferedProducerFind.createConfiguration(location, this) : null;
    }

    @Nullable
    public RunnerAndConfigurationSettings getConfiguration(RuntimeConfigurationProducer producer) {
        this.myConfiguration = producer.getConfiguration();
        return this.myConfiguration;
    }

    Location getLocation() {
        return this.myLocation;
    }

    @Nullable
    public RunnerAndConfigurationSettingsImpl findExisting() {
        if (this.myLocation == null) {
            return null;
        }
        HashSet types = new HashSet();
        if (this.myRuntimeConfiguration != null) {
            types.add(this.myRuntimeConfiguration.getType());
        } else {
            List<RuntimeConfigurationProducer> producers = PreferedProducerFind.findPreferredProducers(this.myLocation, this, true);
            if (producers == null) {
                return null;
            }
            for (RuntimeConfigurationProducer producer : producers) {
                types.add(producer.createProducer(this.myLocation, this).getConfigurationType());
            }
        }
        for (ConfigurationType type : types) {
            RunnerAndConfigurationSettingsImpl[] configurations;
            if (!(type instanceof LocatableConfigurationType)) continue;
            LocatableConfigurationType factoryLocatable = (LocatableConfigurationType)type;
            for (RunnerAndConfigurationSettingsImpl existingConfiguration : configurations = this.getRunManager().getConfigurationSettings(type)) {
                if (!factoryLocatable.isConfigurationByLocation(existingConfiguration.getConfiguration(), this.myLocation)) continue;
                return existingConfiguration;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getSelectedPsiElement(DataContext dataContext, Project project) {
        VirtualFile file;
        PsiFile psiFile;
        PsiElement element = null;
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if (element == null && (file = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataContext)) != null) {
            element = PsiManager.getInstance((Project)project).findFile(file);
        }
        return element;
    }

    public RunManagerEx getRunManager() {
        return RunManagerEx.getInstanceEx(this.getProject());
    }

    public Project getProject() {
        return this.myLocation.getProject();
    }

    public Module getModule() {
        return this.myModule;
    }

    public DataContext getDataContext() {
        return DataManager.getInstance().getDataContext(this.myContextComponent);
    }

    @Nullable
    public RuntimeConfiguration getOriginalConfiguration(ConfigurationType type) {
        return this.myRuntimeConfiguration != null && Comparing.strEqual((String)type.getId(), (String)this.myRuntimeConfiguration.getType().getId()) ? this.myRuntimeConfiguration : null;
    }
}

