/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TerminateRemoteProcessDialog
extends DialogWrapper {
    private JCheckBox myTerminateCheckBox;
    private final String mySessionName;
    private final boolean myDetachIsDefault;

    public TerminateRemoteProcessDialog(Project project, String configurationName, boolean detachIsDefault) {
        super(project, true);
        this.mySessionName = configurationName;
        this.myDetachIsDefault = detachIsDefault;
        this.setTitle(ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{this.mySessionName}));
        this.setOKButtonText(ExecutionBundle.message((String)"button.disconnect", (Object[])new Object[0]));
        this.setButtonsAlignment(0);
        this.init();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected JComponent createNorthPanel() {
        String message = ExecutionBundle.message((String)"disconnect.process.confirmation.text", (Object[])new Object[]{this.mySessionName});
        JLabel label = new JLabel(message);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "Center");
        Icon icon = UIUtil.getOptionPanelWarningIcon();
        if (icon != null) {
            label.setIcon(icon);
            label.setIconTextGap(7);
        }
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myTerminateCheckBox = new JCheckBox(ExecutionBundle.message((String)"terminate.after.disconnect.checkbox", (Object[])new Object[0]));
        this.myTerminateCheckBox.setSelected(!this.myDetachIsDefault);
        panel.add((Component)this.myTerminateCheckBox, "East");
        return panel;
    }

    public boolean forceTermination() {
        return this.myTerminateCheckBox.isSelected();
    }
}

