/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.LayeredIcon;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationExtension {
    public static final ExtensionPointName<RunConfigurationExtension> EP_NAME = new ExtensionPointName("com.intellij.runConfigurationExtension");
    public static final Key<List> RUN_EXTENSIONS = Key.create((String)"run.extension.elemnts");

    public abstract void handleStartProcess(ModuleBasedConfiguration var1, OSProcessHandler var2);

    public abstract <T extends ModuleBasedConfiguration> SettingsEditor createEditor(T var1);

    public abstract String getEditorTitle();

    public abstract String getName();

    @Nullable
    public abstract <T extends ModuleBasedConfiguration> Icon getIcon(T var1);

    public static <T extends ModuleBasedConfiguration> void appendEditors(T configuration, SettingsEditorGroup<T> group) {
        for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions(EP_NAME)) {
            SettingsEditor editor = extension.createEditor(configuration);
            if (editor == null) continue;
            group.addEditor(extension.getEditorTitle(), editor);
        }
    }

    public static <T extends ModuleBasedConfiguration> Icon getIcon(T configuration, Icon icon) {
        for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions(EP_NAME)) {
            Icon extIcon = extension.getIcon(configuration);
            if (extIcon == null) continue;
            return LayeredIcon.create((Icon)icon, (Icon)extIcon);
        }
        return icon;
    }

    public abstract <T extends ModuleBasedConfiguration> void updateJavaParameters(T var1, JavaParameters var2, RunnerSettings var3);

    protected abstract void readExternal(ModuleBasedConfiguration var1, Element var2) throws InvalidDataException;

    public static void readSettings(ModuleBasedConfiguration runConfiguration, Element parentNode) throws InvalidDataException {
        List children = parentNode.getChildren("extension");
        HashMap<String, RunConfigurationExtension> extensions = new HashMap<String, RunConfigurationExtension>();
        for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions(EP_NAME)) {
            extensions.put(extension.getName(), extension);
        }
        boolean found = true;
        for (Object o : children) {
            Element element = (Element)o;
            String extensionName = element.getAttributeValue("name");
            RunConfigurationExtension extension = (RunConfigurationExtension)extensions.remove(extensionName);
            if (extension != null) {
                extension.readExternal(runConfiguration, element);
                continue;
            }
            found = false;
        }
        for (RunConfigurationExtension extension : extensions.values()) {
            extension.readExternal(runConfiguration, parentNode);
        }
        if (!found) {
            runConfiguration.putCopyableUserData(RUN_EXTENSIONS, (Object)children);
        }
    }

    public static void writeSettings(ModuleBasedConfiguration runConfiguration, Element element) throws WriteExternalException {
        TreeMap<String, Element> map = new TreeMap<String, Element>();
        List elements = (List)runConfiguration.getCopyableUserData(RUN_EXTENSIONS);
        if (elements != null) {
            for (Element el : elements) {
                String name = el.getAttributeValue("name");
                map.put(name, (Element)el.clone());
            }
        }
        for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions(EP_NAME)) {
            Element el = new Element("extension");
            el.setAttribute("name", extension.getName());
            extension.writeExternal(runConfiguration, el);
            map.put(extension.getName(), el);
        }
        for (Element val : map.values()) {
            element.addContent(val);
        }
    }

    protected abstract void writeExternal(ModuleBasedConfiguration var1, Element var2) throws WriteExternalException;

    public abstract <T extends ModuleBasedConfiguration> void patchConfiguration(T var1);

    public abstract <T extends ModuleBasedConfiguration> void checkConfiguration(T var1) throws RuntimeConfigurationException;

    public static <T extends ModuleBasedConfiguration> void patchCreatedConfiguration(T configuration) {
        for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions(EP_NAME)) {
            extension.patchConfiguration(configuration);
        }
    }

    public static <T extends ModuleBasedConfiguration> void checkConfigurationIsValid(T configuration) throws RuntimeConfigurationException {
        for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions(EP_NAME)) {
            extension.checkConfiguration(configuration);
        }
    }

    public <T extends ModuleBasedConfiguration> boolean isListenerDisabled(T configuration, Object listener) {
        return false;
    }
}

