/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.Block;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.diff.Diff;

public class FindBlock {
    private final Block myCurrentVersion;
    private final Block myResult;

    public FindBlock(String[] prevVersion, Block currentVersion) {
        this.myResult = new Block(prevVersion, currentVersion.getStart(), currentVersion.getEnd());
        this.myCurrentVersion = currentVersion;
    }

    public FindBlock(String prevVersion, Block currentVersion) {
        this(LineTokenizer.tokenize((char[])prevVersion.toCharArray(), (boolean)false), currentVersion);
    }

    public Block getBlockInThePrevVersion() {
        Diff.Change change = Diff.buildChanges((Object[])this.myResult.getSource(), (Object[])this.myCurrentVersion.getSource());
        while (change != null) {
            this.shiftIndices(change.line1, change.line1, change.line0);
            this.shiftIndices(change.line1, change.line1 + change.inserted, change.line0 + change.deleted);
            change = change.link;
        }
        if (this.myResult.getEnd() >= this.myResult.getSource().length) {
            this.myResult.setEnd(this.myResult.getSource().length - 1);
        }
        return this.myResult;
    }

    private void shiftIndices(int firstChangeIndex, int line1, int line0) {
        int shift = line1 - line0;
        if (line1 <= this.myCurrentVersion.getStart()) {
            this.myResult.setStart(this.myCurrentVersion.getStart() - shift);
        }
        if (firstChangeIndex <= this.myCurrentVersion.getEnd()) {
            this.myResult.setEnd(this.myCurrentVersion.getEnd() - shift);
        }
    }
}

